/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class StarPatternCache {
    private static final ResourceLocation STAR_PATTERN_CACHE = new ResourceLocation("quickskin", "textures/gui/background/star_pattern_cache_generated.png");
    private static final int TILE_SIZE = 55;
    private static final int CACHE_TILES_WIDTH = 64;
    private static final int CACHE_TILES_HEIGHT = 32;
    private static DynamicTexture cachedTexture = null;
    private static ResourceLocation cachedTextureLocation = null;
    private static int cachedTextureWidth = 0;
    private static int cachedTextureHeight = 0;

    public static void initialize() {
        if (cachedTexture != null) {
            return;
        }
        try {
            NativeImage cachedImage;
            Minecraft mc = Minecraft.m_91087_();
            Resource resource = (Resource)mc.m_91098_().m_213713_(STAR_PATTERN_CACHE).orElseThrow();
            try (InputStream stream = resource.m_215507_();){
                cachedImage = NativeImage.m_85058_((InputStream)stream);
            }
            cachedTextureWidth = cachedImage.m_84982_();
            cachedTextureHeight = cachedImage.m_85084_();
            cachedTexture = new DynamicTexture(cachedImage);
            cachedTextureLocation = mc.m_91097_().m_118490_("quickskin_star_cache", cachedTexture);
            QuickSkin.LOGGER.info("Star pattern cache loaded: {}x{} (pre-generated texture)", (Object)cachedTextureWidth, (Object)cachedTextureHeight);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load star pattern cache", (Throwable)e);
        }
    }

    public static ResourceLocation getTextureLocation() {
        if (cachedTextureLocation == null) {
            StarPatternCache.initialize();
        }
        return cachedTextureLocation;
    }

    public static int getTextureWidth() {
        if (cachedTexture == null) {
            StarPatternCache.initialize();
        }
        return cachedTextureWidth;
    }

    public static int getTextureHeight() {
        if (cachedTexture == null) {
            StarPatternCache.initialize();
        }
        return cachedTextureHeight;
    }

    public static int getTileSize() {
        return 55;
    }

    public static void cleanup() {
        if (cachedTexture != null) {
            cachedTexture.close();
            cachedTexture = null;
            cachedTextureLocation = null;
        }
    }
}

