/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.rendering.PreviewPlayerData;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.config.ClientConfig;
import dev.architectury.event.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinPreviewOverlay {
    private static boolean isDragging = false;
    private static int dragStartX;
    private static int dragStartY;
    private static int dragStartOffsetX;
    private static int dragStartOffsetY;
    private static boolean isRightDragging;
    private static int rightDragStartX;
    private static float initialRotationOnDrag;
    private static int cachedModelCenterX;
    private static int cachedModelCenterY;
    private static float cachedScale;
    private static ResourceLocation cachedSkinLocation;
    private static String cachedModelType;
    private static String lastCheckedSkinHash;

    public static void render(GuiGraphics guiGraphics, float tickDelta) {
        int percentage;
        boolean needsUpdate;
        boolean isChatOpen;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (mc.f_91080_ != null && !(isChatOpen = mc.f_91080_ instanceof ChatScreen)) {
            return;
        }
        ClientConfig config = ClientConfig.getInstance();
        String activeSkinHash = config.activeSkinHash;
        boolean bl = needsUpdate = lastCheckedSkinHash == null || !lastCheckedSkinHash.equals(activeSkinHash);
        if (needsUpdate) {
            lastCheckedSkinHash = activeSkinHash;
            if (!activeSkinHash.isEmpty()) {
                LocalAssetManager assetManager = LocalAssetManager.getInstance();
                AssetMetadata metadata = assetManager.getMetadata(activeSkinHash);
                if (metadata != null) {
                    cachedSkinLocation = assetManager.getTextureLocation(activeSkinHash, TextureQuality.FULL);
                    String skinModelPref = assetManager.getSkinModelPreference(activeSkinHash);
                    cachedModelType = "auto".equals(skinModelPref) ? metadata.skinModel() : skinModelPref;
                }
            } else {
                cachedSkinLocation = player.m_108560_();
                cachedModelType = player.m_108564_();
                if ("default".equals(cachedModelType)) {
                    cachedModelType = "classic";
                }
            }
        }
        if (cachedSkinLocation == null) {
            cachedSkinLocation = player.m_108560_();
            cachedModelType = "classic";
        }
        if ((percentage = config.sizeModelPreviewPercentageHudOverlay) == 0) {
            percentage = 30;
        }
        float percentageAsFloat = (float)(percentage - 1) / 99.0f;
        float scale = 20.0f + percentageAsFloat * 180.0f;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int hotbarCenterX = screenWidth / 2;
        int hotbarCenterY = screenHeight - 22;
        int modelCenterX = hotbarCenterX + config.positionOffsetXHudOverlay;
        int modelCenterY = hotbarCenterY + config.positionOffsetYHudOverlay;
        cachedModelCenterX = modelCenterX;
        cachedModelCenterY = modelCenterY;
        cachedScale = scale;
        float rotationAngle = config.hudOverlayRotation;
        SkinPreviewOverlay.renderPlayerPreview(guiGraphics, modelCenterX, modelCenterY, scale, cachedSkinLocation, cachedModelType, rotationAngle);
        if (config.enablePlayerPreviewCustomization) {
            SkinPreviewOverlay.renderModelBorder(guiGraphics, modelCenterX, modelCenterY, scale);
        }
    }

    private static void renderModelBorder(GuiGraphics graphics, int centerX, int centerY, float scale) {
        int modelHeight = (int)(scale * 2.0f);
        int modelWidth = (int)((float)modelHeight * 0.6f);
        int left = centerX - modelWidth / 2;
        int right = centerX + modelWidth / 2;
        int top = centerY - modelHeight;
        Font font = Minecraft.m_91087_().f_91062_;
        String instructionText = "LMB: move | RMB: rotate | Wheel: resize";
        int textWidth = font.m_92895_(instructionText);
        int textX = centerX - textWidth / 2;
        int textY = top - 12;
        int textColor = -1;
        graphics.m_280056_(font, instructionText, textX, textY, textColor, true);
        int borderColor = -16711936;
        graphics.m_280509_(left, top, right, top + 2, borderColor);
        graphics.m_280509_(left, centerY - 2, right, centerY, borderColor);
        graphics.m_280509_(left, top, left + 2, centerY, borderColor);
        graphics.m_280509_(right - 2, top, right, centerY, borderColor);
        int crosshairSize = 5;
        int crosshairColor = -65536;
        graphics.m_280509_(centerX - crosshairSize, centerY - 1, centerX + crosshairSize, centerY + 1, crosshairColor);
        graphics.m_280509_(centerX - 1, centerY - crosshairSize, centerX + 1, centerY + crosshairSize, crosshairColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderPlayerPreview(GuiGraphics graphics, int x, int y, float scale, ResourceLocation skinTexture, String modelType, float rotation) {
        PreviewPlayerData previewData = new PreviewPlayerData();
        previewData.setSkinLocation(skinTexture);
        previewData.setCapeLocation(null);
        previewData.setModelType(modelType);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        try {
            PlayerModelRenderer.renderPlayerModel(graphics, x, y, scale, rotation, previewData, 0, 0, false);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    private static boolean isMouseOver(double mouseX, double mouseY) {
        int modelHeight = (int)(cachedScale * 2.0f);
        int modelWidth = (int)((float)modelHeight * 0.6f);
        int left = cachedModelCenterX - modelWidth / 2;
        int right = cachedModelCenterX + modelWidth / 2;
        int top = cachedModelCenterY - modelHeight;
        return mouseX >= (double)left && mouseX <= (double)right && mouseY >= (double)top && mouseY <= (double)cachedModelCenterY;
    }

    public static EventResult onMouseClicked(double mouseX, double mouseY, int button) {
        ClientConfig config = ClientConfig.getInstance();
        if (!config.showSkinPreviewOverlay || !config.enablePlayerPreviewCustomization || button != 0) {
            isDragging = false;
            return EventResult.pass();
        }
        if (SkinPreviewOverlay.isMouseOver(mouseX, mouseY)) {
            isDragging = true;
            dragStartX = (int)mouseX;
            dragStartY = (int)mouseY;
            dragStartOffsetX = config.positionOffsetXHudOverlay;
            dragStartOffsetY = config.positionOffsetYHudOverlay;
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseReleased(double mouseX, double mouseY, int button) {
        if (isDragging && button == 0) {
            isDragging = false;
            ClientConfig.getInstance().save();
            return EventResult.interruptTrue();
        }
        if (isRightDragging && button == 1) {
            isRightDragging = false;
            ClientConfig.getInstance().save();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (isDragging && button == 0) {
            ClientConfig config = ClientConfig.getInstance();
            int newOffsetX = dragStartOffsetX + (int)(mouseX - (double)dragStartX);
            int newOffsetY = dragStartOffsetY + (int)(mouseY - (double)dragStartY);
            config.positionOffsetXHudOverlay = newOffsetX;
            config.positionOffsetYHudOverlay = newOffsetY;
            return EventResult.interruptTrue();
        }
        if (isRightDragging && button == 1) {
            ClientConfig config = ClientConfig.getInstance();
            float rotationDelta = (float)(mouseX - (double)rightDragStartX) * 0.5f;
            config.hudOverlayRotation = initialRotationOnDrag - rotationDelta;
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onRightMouseClicked(double mouseX, double mouseY, int button) {
        ClientConfig config = ClientConfig.getInstance();
        if (!config.showSkinPreviewOverlay || !config.enablePlayerPreviewCustomization || button != 1) {
            isRightDragging = false;
            return EventResult.pass();
        }
        if (SkinPreviewOverlay.isMouseOver(mouseX, mouseY)) {
            isRightDragging = true;
            rightDragStartX = (int)mouseX;
            initialRotationOnDrag = config.hudOverlayRotation;
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseScrolled(double mouseX, double mouseY, double delta) {
        ClientConfig config = ClientConfig.getInstance();
        if (!config.showSkinPreviewOverlay || !config.enablePlayerPreviewCustomization) {
            return EventResult.pass();
        }
        if (SkinPreviewOverlay.isMouseOver(mouseX, mouseY)) {
            int oldPercentage = config.sizeModelPreviewPercentageHudOverlay;
            if (oldPercentage == 0) {
                oldPercentage = 30;
            }
            int newPercentage = oldPercentage + (int)Math.round(delta * 5.0);
            if ((newPercentage = Mth.m_14045_((int)newPercentage, (int)1, (int)100)) != oldPercentage) {
                config.sizeModelPreviewPercentageHudOverlay = newPercentage;
                config.save();
            }
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    static {
        isRightDragging = false;
        cachedSkinLocation = null;
        cachedModelType = "classic";
        lastCheckedSkinHash = null;
    }
}

