/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.panel;

import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.widget.SkinEntry;
import com.quickskin.mod.client.gui.widget.SkinListWidget;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SkinListPanel
extends AbstractWidget {
    @Nullable
    private SkinListWidget skinListWidget;
    private final Minecraft minecraft;
    private final Consumer<SkinEntry> onSkinSelectedCallback;

    public SkinListPanel(int x, int y, int width, int height, Minecraft minecraft, Consumer<SkinEntry> onSkinSelectedCallback) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.minecraft = minecraft;
        this.onSkinSelectedCallback = onSkinSelectedCallback;
    }

    public void init(PlayerSkinMenuScreen screen) {
        this.skinListWidget = new SkinListWidget(screen, this.minecraft, this.f_93618_, this.f_93619_, this.m_252907_(), 40);
        this.skinListWidget.m_93507_(this.m_252754_());
        this.skinListWidget.m_93488_(false);
        this.skinListWidget.m_93496_(false);
        screen.registerWidget(this.skinListWidget);
        this.loadSkins();
    }

    private void loadSkins() {
        if (this.skinListWidget == null) {
            return;
        }
        LocalAssetManager assetManager = LocalAssetManager.getInstance();
        List<AssetMetadata> skins = assetManager.getAllSkins();
        for (AssetMetadata metadata : skins) {
            this.skinListWidget.addSkinEntry(metadata);
        }
    }

    public void refresh() {
        if (this.skinListWidget == null) {
            return;
        }
        this.skinListWidget.clearSkinEntries();
        this.loadSkins();
    }

    public void setSelected(AssetMetadata metadata) {
        this.setSelected(metadata, true);
    }

    public void setSelected(AssetMetadata metadata, boolean triggerCallback) {
        if (this.skinListWidget == null || metadata == null) {
            return;
        }
        for (int i = 0; i < this.skinListWidget.m_6702_().size(); ++i) {
            SkinEntry entry = (SkinEntry)((Object)this.skinListWidget.m_6702_().get(i));
            if (!entry.getMetadata().hash().equals(metadata.hash())) continue;
            this.skinListWidget.m_6987_((AbstractSelectionList.Entry)entry);
            if (triggerCallback) {
                this.onSkinSelectedCallback.accept(entry);
            }
            this.skinListWidget.makeVisible(entry);
            break;
        }
    }

    @Nullable
    public SkinListWidget getSkinListWidget() {
        return this.skinListWidget;
    }

    @Nullable
    public SkinEntry getSelected() {
        if (this.skinListWidget == null) {
            return null;
        }
        return (SkinEntry)this.skinListWidget.m_93511_();
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

