/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.StarPatternCache;
import com.quickskin.mod.client.gui.screen.CapeEntry;
import com.quickskin.mod.client.gui.screen.DeletionConfirmScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.util.FileDialogHelper;
import com.quickskin.mod.client.gui.util.GuiScalingUtils;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CapeService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.KnownCapes;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.common.data.SkinResolution;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.common.util.HDTextureProcessor;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.common.util.StbGifLoader;
import com.quickskin.mod.config.ClientConfig;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerCapeMenuScreen
extends Screen {
    private static final ResourceLocation STAR_PATTERN_TEXTURE = new ResourceLocation("quickskin", "textures/gui/background/star_pattern.png");
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");
    private static final int BASE_CAPE_DISPLAY_SIZE = 64;
    private static final int BASE_CAPE_PADDING = 8;
    private static final int BASE_SCROLL_SPEED = 20;
    private static final int ACTION_BUTTON_SIZE = 11;
    private static final int HEADER_HEIGHT = 20;
    private static final int MIN_GRID_WIDTH = 300;
    private static final int MAX_GRID_WIDTH = 600;
    private static final int MIN_GRID_HEIGHT = 200;
    private static final int MAX_GRID_HEIGHT = 500;
    private int capeDisplaySize;
    private int capePadding;
    private int capesPerRow;
    private int scrollSpeed;
    @Nullable
    private final Screen parent;
    private PlayerWidget playerWidget;
    private SpeedSlider animationSpeedSlider;
    private static final int MODEL_OFFSET_X = 95;
    private static final int MODEL_OFFSET_Y = 121;
    private double scrollOffset = 0.0;
    private double targetScrollOffset = 0.0;
    private int maxScroll = 0;
    private boolean isDraggingScrollbar = false;
    private double scrollbarClickOffset = 0.0;
    private int totalContentHeight = 0;
    private int gridX;
    private int gridY;
    private int gridWidth;
    private int gridHeight;
    private int playerWidgetX;
    private int playerWidgetY;
    private float savedBodyYaw = 20.0f;
    private float savedTargetRotation = 200.0f;
    private int playerWidgetWidth;
    private int playerWidgetHeight;
    @Nullable
    private CapeEntry selectedCape;
    private final List<CapeEntry> localCapes = new ArrayList<CapeEntry>();
    private final List<CapeEntry> knownCapes = new ArrayList<CapeEntry>();
    private String importMessage = "";
    private int importMessageTimer = 0;
    private int importMessageColor = 0xFFFFFF;

    public PlayerCapeMenuScreen(@Nullable Screen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
    }

    protected void m_7856_() {
        LocalAssetManager assetManager;
        AssetMetadata metadata;
        int widgetSize;
        if (this.playerWidget != null) {
            this.savedBodyYaw = this.playerWidget.getBodyYaw();
            this.savedTargetRotation = this.playerWidget.getTargetYRotation();
        }
        super.m_7856_();
        this.calculateAdaptiveDimensions();
        int desiredGridWidth = (int)((float)this.f_96543_ * 0.55f);
        this.gridWidth = Mth.m_14045_((int)desiredGridWidth, (int)300, (int)Math.min(600, this.f_96543_ - this.scaleValue(200)));
        int gridTopY = this.scaleValue(40);
        int bottomButtonY = this.f_96544_ - this.scaleValue(60);
        int availableHeight = bottomButtonY - gridTopY - this.scaleValue(10);
        this.gridHeight = Mth.m_14045_((int)availableHeight, (int)200, (int)500);
        int buttonSpacing = 10;
        int buttonWidth = Math.min(150, (this.f_96543_ - 60 - buttonSpacing * 2) / 3);
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = (this.f_96543_ - totalButtonWidth) / 2;
        int backButtonX = buttonStartX + (buttonWidth + buttonSpacing) * 2;
        int gridRightEdge = backButtonX + (int)((float)buttonWidth * 0.25f);
        this.gridX = gridRightEdge - this.gridWidth;
        this.gridY = gridTopY;
        this.refineCapesPerRowForGridWidth();
        this.refreshCapeList();
        this.updateGridDimensions();
        int bottomY = this.f_96544_ - this.scaleValue(60);
        Button importButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createStyled(buttonStartX, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Import Cape"), button -> this.importCape()));
        Button removeButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createStyled(buttonStartX + buttonWidth + buttonSpacing, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Remove Cape"), button -> this.removeCape()));
        Button closeButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createPrimary(buttonStartX + (buttonWidth + buttonSpacing) * 2, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()));
        int sliderWidth = 200;
        int sliderHeight = 20;
        int sliderX = (this.f_96543_ - sliderWidth) / 2;
        int sliderY = bottomY + this.scaleValue(20) + 5;
        this.animationSpeedSlider = (SpeedSlider)this.m_142416_((GuiEventListener)new SpeedSlider(sliderX, sliderY, sliderWidth, sliderHeight));
        this.animationSpeedSlider.f_93624_ = false;
        this.animationSpeedSlider.f_93623_ = false;
        int availableWidthForWidget = this.f_96543_ - (this.gridX + this.gridWidth) - this.scaleValue(40);
        int availableHeightForWidget = bottomY - this.gridY - this.scaleValue(20);
        this.playerWidgetWidth = widgetSize = Mth.m_14045_((int)Math.min(availableWidthForWidget, availableHeightForWidget), (int)this.scaleValue(100), (int)this.scaleValue(200));
        this.playerWidgetHeight = (int)((float)widgetSize * 1.8f);
        if (this.playerWidgetX == 0 && this.playerWidgetY == 0) {
            int gridRight = this.gridX + this.gridWidth;
            int gridCenter = this.gridY + this.gridHeight / 2;
            this.playerWidgetX = gridRight + this.scaleValue(20);
            this.playerWidgetY = gridCenter - this.playerWidgetHeight / 2;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ResourceLocation skinLocation = null;
        String modelType = "classic";
        ClientConfig config = ClientConfig.getInstance();
        if (!config.activeSkinHash.isEmpty() && (metadata = (assetManager = LocalAssetManager.getInstance()).getMetadata(config.activeSkinHash)) != null) {
            skinLocation = assetManager.getTextureLocation(config.activeSkinHash, TextureQuality.FULL);
            modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
            if ("auto".equals(modelType)) {
                modelType = metadata.skinModel();
            }
        }
        if (skinLocation == null && player != null) {
            skinLocation = player.m_108560_();
            if (!config.activeSkinHash.isEmpty()) {
                assetManager = LocalAssetManager.getInstance();
                modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                metadata = assetManager.getMetadata(config.activeSkinHash);
                if ("auto".equals(modelType) && metadata != null) {
                    modelType = metadata.skinModel();
                } else {
                    modelType = player.m_108564_();
                    if ("default".equals(modelType)) {
                        modelType = "classic";
                    }
                }
            } else if ("auto".equals(modelType) && "default".equals(modelType = player.m_108564_())) {
                modelType = "classic";
            }
        }
        if (skinLocation == null) {
            skinLocation = new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
            modelType = "classic";
        }
        this.playerWidget = (PlayerWidget)this.m_142416_((GuiEventListener)new PlayerWidget(this.playerWidgetX, this.playerWidgetY, this.playerWidgetWidth, this.playerWidgetHeight, skinLocation, null, null, modelType));
        this.playerWidget.setContext(PlayerWidget.WidgetContext.CAPE_MENU);
        int referenceX = this.gridX + this.gridWidth + 95;
        int referenceY = this.gridY + this.gridHeight / 2 + 121;
        this.playerWidget.setCustomReferencePoint(referenceX, referenceY);
        this.initializeSelectedCape();
        this.updateSpeedSliderVisibility();
        this.playerWidget.setRotationState(this.savedBodyYaw, this.savedTargetRotation);
    }

    private void calculateAdaptiveDimensions() {
        float scale = GuiScalingUtils.getScaleMultiplier(this.f_96543_, this.f_96544_);
        this.capeDisplaySize = Math.max(48, Math.min(96, Math.round(64.0f * scale)));
        this.capePadding = Math.max(4, Math.round(8.0f * scale));
        this.scrollSpeed = Math.max(10, Math.round(20.0f * scale));
        int estimatedGridWidth = (int)((float)this.f_96543_ * 0.55f);
        int capeWithPadding = this.capeDisplaySize + this.capePadding;
        this.capesPerRow = Mth.m_14045_((int)((estimatedGridWidth - this.capePadding * 2) / capeWithPadding), (int)2, (int)8);
        if (GuiScalingUtils.isSmallScreen(this.f_96543_, this.f_96544_)) {
            this.capesPerRow = Math.max(2, this.capesPerRow - 1);
            this.capeDisplaySize = Math.round((float)this.capeDisplaySize * 0.85f);
        }
        if (GuiScalingUtils.isLargeScreen(this.f_96543_, this.f_96544_)) {
            this.capesPerRow = Math.min(10, this.capesPerRow + 1);
        }
    }

    private void refineCapesPerRowForGridWidth() {
        int capeWithPadding = this.capeDisplaySize + this.capePadding;
        int availableWidth = this.gridWidth - this.capePadding * 2;
        int maxPerRow = Math.max(2, availableWidth / capeWithPadding);
        this.capesPerRow = Mth.m_14045_((int)maxPerRow, (int)2, (int)10);
    }

    private int scaleValue(int baseValue) {
        return GuiScalingUtils.scaleValue(baseValue, this.f_96543_, this.f_96544_);
    }

    public void refreshCapeList() {
        this.localCapes.clear();
        this.knownCapes.clear();
        this.localCapes.add(CapeEntry.fromKnown(KnownCapes.NONE));
        List<AssetMetadata> localCapeAssets = LocalAssetManager.getInstance().getAssetsByType("cape");
        for (AssetMetadata localCape : localCapeAssets) {
            this.localCapes.add(CapeEntry.fromLocal(localCape));
        }
        for (KnownCapes knownCape : KnownCapes.values()) {
            if (knownCape.isNoCape()) continue;
            this.knownCapes.add(CapeEntry.fromKnown(knownCape));
        }
        QuickSkin.LOGGER.debug("Loaded {} local capes (including None) + {} default capes", (Object)this.localCapes.size(), (Object)this.knownCapes.size());
        this.registerAllAnimations();
    }

    private void registerAllAnimations() {
        String capeId;
        CapeService capeService = CapeService.getInstance();
        for (CapeEntry cape : this.localCapes) {
            if (!cape.isAnimated()) continue;
            capeId = cape.getCapeId();
            capeService.getCapeLocation(null, capeId);
        }
        for (CapeEntry cape : this.knownCapes) {
            if (!cape.isAnimated()) continue;
            capeId = cape.getCapeId();
            capeService.getCapeLocation(null, capeId);
        }
        QuickSkin.LOGGER.info("Pre-registered animations for all animated capes in the menu");
    }

    private void initializeSelectedCape() {
        String activeCapeId = null;
        ClientConfig config = ClientConfig.getInstance();
        if (!config.activeCapeHash.isEmpty()) {
            activeCapeId = config.activeCapeHash;
            QuickSkin.LOGGER.debug("Found active cape in config: {}", (Object)activeCapeId);
        }
        if (activeCapeId == null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            UUID playerId = this.f_96541_.f_91074_.m_20148_();
            PlayerAppearance appearance = PlayerAppearanceService.getInstance().getAppearance(playerId);
            if (appearance != null && appearance.getCapeId() != null && !appearance.getCapeId().isEmpty()) {
                activeCapeId = appearance.getCapeId();
                QuickSkin.LOGGER.debug("Found active cape in PlayerAppearanceService: {}", (Object)activeCapeId);
            }
        }
        if (activeCapeId == null || activeCapeId.isEmpty()) {
            QuickSkin.LOGGER.debug("No active cape found");
            this.selectedCape = null;
            return;
        }
        for (CapeEntry cape : this.localCapes) {
            if (!cape.getCapeId().equals(activeCapeId)) continue;
            this.selectedCape = cape;
            ResourceLocation capeLocation = cape.getTextureLocation();
            if (capeLocation != null && this.playerWidget != null) {
                this.playerWidget.setCape(capeLocation, cape.getCapeId());
            }
            QuickSkin.LOGGER.info("Initialized selected cape: {}", (Object)cape.getFriendlyName());
            return;
        }
        for (CapeEntry cape : this.knownCapes) {
            if (!cape.getCapeId().equals(activeCapeId)) continue;
            this.selectedCape = cape;
            ResourceLocation capeLocation = cape.getTextureLocation();
            if (capeLocation != null && this.playerWidget != null) {
                this.playerWidget.setCape(capeLocation, cape.getCapeId());
            }
            QuickSkin.LOGGER.info("Initialized selected cape: {}", (Object)cape.getFriendlyName());
            return;
        }
        QuickSkin.LOGGER.warn("Could not find cape with ID '{}' in capes lists", (Object)activeCapeId);
        this.selectedCape = null;
    }

    private void updateSpeedSliderVisibility() {
        if (this.animationSpeedSlider == null) {
            return;
        }
        boolean show = false;
        if (this.selectedCape != null && this.selectedCape.isAnimated()) {
            show = true;
            this.animationSpeedSlider.loadSpeedForCurrentCape();
        }
        this.animationSpeedSlider.f_93624_ = show;
        this.animationSpeedSlider.f_93623_ = show;
    }

    private void updateGridDimensions() {
        int totalHeight = 0;
        if (!this.localCapes.isEmpty()) {
            totalHeight += 20;
            int localRows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            totalHeight += localRows * (this.capeDisplaySize + this.capePadding);
        }
        if (!this.knownCapes.isEmpty()) {
            totalHeight += 40;
            int knownRows = (int)Math.ceil((double)this.knownCapes.size() / (double)this.capesPerRow);
            totalHeight += knownRows * (this.capeDisplaySize + this.capePadding);
        }
        this.totalContentHeight = totalHeight + this.capePadding;
        this.maxScroll = Math.max(0, this.totalContentHeight - this.gridHeight);
    }

    private void importCape() {
        FileDialogHelper.openCapeFileDialog("Select Cape File", this::handleCapeImport);
    }

    private void handleCapeImport(Path filePath) {
        if (filePath == null) {
            return;
        }
        QuickSkin.LOGGER.info("Importing cape: {}", (Object)filePath);
        this.showImportMessage("Processing cape...", 0x55AAFF, 60);
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> {
                Path capesDir = LocalAssetManager.getInstance().getCapesDirectory();
                try {
                    Files.createDirectories(capesDir, new FileAttribute[0]);
                    if (this.processDroppedFile(filePath, capesDir)) {
                        QuickSkin.LOGGER.info("Successfully imported cape: {}", (Object)filePath.getFileName());
                        LocalAssetManager.getInstance().reload();
                        this.refreshCapeList();
                        this.updateGridDimensions();
                        this.showImportMessage("\u2713 Imported cape", 0x55FF55, 100);
                    } else {
                        QuickSkin.LOGGER.error("Failed to import cape: {}", (Object)filePath);
                        this.showImportMessage("\u26a0 Invalid cape file (must be 2:1 ratio or animation strip)", 0xFF5555, 150);
                    }
                }
                catch (IOException e) {
                    QuickSkin.LOGGER.error("Failed to import cape", (Throwable)e);
                    this.showImportMessage("\u26a0 Error: " + e.getMessage(), 0xFF5555, 150);
                }
            });
        }
    }

    private void removeCape() {
        this.playerWidget.setCape(null, null);
        this.selectedCape = null;
        this.updateSpeedSliderVisibility();
        ClientConfig config = ClientConfig.getInstance();
        config.activeCapeHash = "";
        config.save();
        QuickSkin.LOGGER.info("Cleared cape from config");
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            PlayerAppearanceService.getInstance().applyCape(this.f_96541_.f_91074_.m_20148_(), "");
            QuickSkin.LOGGER.info("Removed cape from in-game player");
        } else {
            UUID dummyUUID = this.getDummyPlayerUUID();
            if (dummyUUID != null) {
                PlayerAppearanceService.getInstance().applyCape(dummyUUID, "");
                QuickSkin.LOGGER.info("Removed cape from cached player");
            } else {
                QuickSkin.LOGGER.info("Removed cape from preview only");
            }
        }
    }

    public void showDeleteConfirmation(CapeEntry capeEntry) {
        if (!capeEntry.isLocal()) {
            return;
        }
        if (this.f_96541_ == null) {
            return;
        }
        String displayName = this.truncateFileName(capeEntry.getFriendlyName());
        this.f_96541_.m_91152_((Screen)new DeletionConfirmScreen(this, (Component)Component.m_237113_((String)"Delete Cape?"), (Component)Component.m_237113_((String)("Are you sure you want to delete '" + displayName + "'?")), confirmed -> {
            if (confirmed.booleanValue()) {
                this.deleteCape(capeEntry);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, true));
    }

    private String truncateFileName(String name) {
        int maxLength = 35;
        if (name.length() <= maxLength) {
            return name;
        }
        return name.substring(0, maxLength - 3) + "...";
    }

    private void deleteCape(CapeEntry capeEntry) {
        if (!capeEntry.isLocal() || capeEntry.getLocalCape() == null) {
            return;
        }
        Path capePath = capeEntry.getPath();
        if (capePath == null) {
            QuickSkin.LOGGER.error("Cannot delete cape: path is null");
            return;
        }
        boolean wasSelected = this.selectedCape != null && this.selectedCape.getCapeId().equals(capeEntry.getCapeId());
        try {
            Files.deleteIfExists(capePath);
            LocalAssetManager.getInstance().discoverLocalAssets();
            this.refreshCapeList();
            this.updateGridDimensions();
            if (wasSelected) {
                this.removeCape();
            }
            QuickSkin.LOGGER.info("Deleted cape: {}", (Object)capeEntry.getFriendlyName());
            this.showImportMessage("\u2713 Deleted cape", 0x55FF55, 100);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to delete cape", (Throwable)e);
            this.showImportMessage("\u26a0 Failed to delete cape", 0xFF5555, 100);
        }
    }

    private void showImportMessage(String message, int color, int duration) {
        this.importMessage = message;
        this.importMessageColor = color;
        this.importMessageTimer = duration;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.importMessageTimer > 0) {
            --this.importMessageTimer;
        }
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        this.renderStarPattern(graphics, partialTick);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f);
        graphics.m_280398_(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.f_96541_ != null ? this.f_96541_.f_91065_.m_93079_() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        ResourceLocation cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)this.f_96543_ / (float)cacheWidth;
        float v1 = (float)this.f_96544_ / (float)cacheHeight;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cacheTexture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, (float)this.f_96544_, 0.0f).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)this.f_96543_, (float)this.f_96544_, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)this.f_96543_, 0.0f, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        CapeEntry hoveredCape;
        this.renderBackgroundEffects(graphics, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.scaleValue(15), 0xFFFFFF);
        graphics.m_280509_(this.gridX - 5, this.gridY - 5, this.gridX + this.gridWidth + 5, this.gridY + this.gridHeight + 5, -1342177280);
        graphics.m_280588_(this.gridX, this.gridY, this.gridX + this.gridWidth, this.gridY + this.gridHeight);
        this.scrollOffset += (this.targetScrollOffset - this.scrollOffset) * 0.5;
        this.renderCapeGrid(graphics, mouseX, mouseY);
        graphics.m_280618_();
        this.renderScrollbar(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.importMessageTimer > 0 && !this.importMessage.isEmpty()) {
            int messageY = this.gridY + this.gridHeight + 10;
            graphics.m_280137_(this.f_96547_, this.importMessage, this.f_96543_ / 2, messageY, this.importMessageColor);
        }
        if (this.isMouseOverGrid(mouseX, mouseY) && (hoveredCape = this.getCapeAt(mouseX, mouseY)) != null) {
            int y;
            int deleteButtonY;
            int margin;
            int x;
            int deleteButtonX;
            boolean deleteHovered = false;
            int[] pos = this.getCapePosition(hoveredCape);
            if (pos != null && hoveredCape.isLocal() && this.isMouseOver(mouseX, mouseY, deleteButtonX = (x = pos[0]) + this.capeDisplaySize - 11 - (margin = 2), deleteButtonY = (y = pos[1]) + margin, 11, 11)) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Delete"), mouseX, mouseY);
                deleteHovered = true;
            }
            if (!deleteHovered) {
                graphics.m_280677_(this.f_96547_, this.getCapeTooltip(hoveredCape), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private void renderCapeGrid(GuiGraphics graphics, int mouseX, int mouseY) {
        int currentY = this.gridY - (int)this.scrollOffset;
        if (!this.localCapes.isEmpty()) {
            currentY = this.renderSection(graphics, "My Capes", this.localCapes, currentY, mouseX, mouseY, true);
        }
        if (!this.knownCapes.isEmpty()) {
            this.renderSection(graphics, "Default Capes", this.knownCapes, currentY + 20, mouseX, mouseY, false);
        }
    }

    private int renderSection(GuiGraphics graphics, String title, List<CapeEntry> capes, int startY, int mouseX, int mouseY, boolean isLocalSection) {
        int headerY = startY + 10 - 4;
        if (headerY > this.gridY - 8 && headerY < this.gridY + this.gridHeight + 8) {
            int gridCenterX = this.gridX + this.gridWidth / 2;
            graphics.m_280137_(this.f_96547_, title, gridCenterX, headerY, 0xFFFFFF);
        }
        int currentY = startY + 20;
        for (int i = 0; i < capes.size(); ++i) {
            CapeEntry cape = capes.get(i);
            int row = i / this.capesPerRow;
            int col = i % this.capesPerRow;
            int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
            int y = currentY + this.capePadding + row * (this.capeDisplaySize + this.capePadding);
            if (y + this.capeDisplaySize < this.gridY || y > this.gridY + this.gridHeight) continue;
            this.renderCapeEntry(graphics, cape, x, y, mouseX, mouseY);
        }
        if (isLocalSection && capes.size() < this.capesPerRow) {
            int col = capes.size() % this.capesPerRow;
            int dropZoneX = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
            int dropZoneY = currentY + this.capePadding;
            int dropZoneWidth = this.gridX + this.gridWidth - dropZoneX - this.capePadding;
            int dropZoneHeight = this.capeDisplaySize;
            if (dropZoneWidth > this.capePadding) {
                this.renderDropZone(graphics, dropZoneX, dropZoneY, dropZoneWidth, dropZoneHeight, mouseX, mouseY);
            }
        }
        int rows = (int)Math.ceil((double)capes.size() / (double)this.capesPerRow);
        return currentY + rows * (this.capeDisplaySize + this.capePadding);
    }

    private void renderDropZone(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        boolean isHovering = this.isMouseOver(mouseX, mouseY, x, y, width, height) && mouseY >= this.gridY && mouseY < this.gridY + this.gridHeight;
        int bgColor = isHovering ? 0x2AFFFFFF : 0x1AFFFFFF;
        graphics.m_280509_(x, y, x + width, y + height, bgColor);
        this.drawDashedBorder(graphics, x, y, width, height, isHovering);
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        MutableComponent mainMessage = Component.m_237113_((String)"Drop cape files here");
        MutableComponent subMessage = Component.m_237113_((String)"or click 'Import Cape'");
        int mainColor = isHovering ? 0xFFFFFF : 0xE0E0E0;
        int subColor = isHovering ? 0xB0B0B0 : 0x909090;
        double d = height;
        Objects.requireNonNull(this.f_96547_);
        if (d > 9.0 * 2.5 && width > this.f_96547_.m_92852_((FormattedText)subMessage)) {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)mainMessage, centerX, centerY - 9 / 2 - 1, mainColor);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)subMessage, centerX, centerY + 9 / 2 + 1, subColor);
        } else if (width > this.f_96547_.m_92852_((FormattedText)mainMessage)) {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)mainMessage, centerX, centerY - 9 / 2, mainColor);
        }
    }

    private void drawDashedBorder(GuiGraphics graphics, int x, int y, int width, int height, boolean highlight) {
        int segmentLength;
        int i;
        int color = highlight ? -1 : -2130706433;
        int dashLength = 8;
        int gapLength = 4;
        int totalLength = dashLength + gapLength;
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y, x + i + segmentLength, y + 1, color);
        }
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y + height - 1, x + i + segmentLength, y + height, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x, y + i, x + 1, y + i + segmentLength, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x + width - 1, y + i, x + width, y + i + segmentLength, color);
        }
    }

    private void renderCapeEntry(GuiGraphics graphics, CapeEntry cape, int x, int y, int mouseX, int mouseY) {
        boolean hovered = this.isMouseOver(mouseX, mouseY, x, y, this.capeDisplaySize, this.capeDisplaySize);
        if (cape.isKnown() && cape.getKnownCape() != null && cape.getKnownCape().isNoCape()) {
            graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, -1879048192);
            graphics.m_280137_(this.f_96547_, "None", x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2 - 4, 0xFFFFFF);
            if (this.isSelected(cape)) {
                graphics.m_280637_(x - 2, y - 2, this.capeDisplaySize + 4, this.capeDisplaySize + 4, -256);
            } else if (hovered) {
                graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, 0x33FFFFFF);
            }
            return;
        }
        ResourceLocation texture = cape.getTextureLocation();
        if (texture != null && cape.isAnimated()) {
            texture = AnimatedTextureManager.getInstance().getAnimationFrame(texture).orElse(texture);
        }
        if (texture != null) {
            this.renderCapeTexture(graphics, texture, cape, x, y);
        } else {
            this.renderLoadingTexture(graphics, x, y);
        }
        if (cape.isCustom()) {
            this.renderCustomIndicator(graphics, x, y);
        }
        if (cape.isAnimated()) {
            this.renderAnimatedIndicator(graphics, x, y);
        }
        if (this.isSelected(cape)) {
            graphics.m_280637_(x - 2, y - 2, this.capeDisplaySize + 4, this.capeDisplaySize + 4, -256);
        } else if (hovered) {
            graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, 0x33FFFFFF);
        }
        if (hovered && cape.isLocal() && !cape.isKnown()) {
            int margin = 2;
            int deleteButtonX = x + this.capeDisplaySize - 11 - margin;
            int deleteButtonY = y + margin;
            boolean deleteHovered = this.isMouseOver(mouseX, mouseY, deleteButtonX, deleteButtonY, 11, 11);
            int deleteBgColor = deleteHovered ? -1595916224 : -2134900736;
            graphics.m_280509_(deleteButtonX, deleteButtonY, deleteButtonX + 11, deleteButtonY + 11, deleteBgColor);
            graphics.m_280488_(this.f_96547_, "x", deleteButtonX + 3, deleteButtonY + 1, -1);
        }
    }

    private void renderCapeTexture(GuiGraphics graphics, ResourceLocation texture, CapeEntry cape, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureWidth = 64;
        int textureHeight = 32;
        if (cape.isLocal() && cape.getLocalCape() != null && cape.getLocalCape().resolution() != null && cape.getLocalCape().resolution().isHD()) {
            int scale = cape.getLocalCape().resolution().getScale();
            textureWidth *= scale;
            textureHeight *= scale;
        }
        boolean u = true;
        boolean v = true;
        int uWidth = 10;
        int vHeight = 16;
        float scaleFactor = (float)this.capeDisplaySize / 56.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x + (float)this.capeDisplaySize / 2.0f, (float)y + (float)this.capeDisplaySize / 2.0f, 0.0f);
        graphics.m_280168_().m_85841_(scaleFactor * 3.5f, scaleFactor * 3.5f, 1.0f);
        graphics.m_280168_().m_252880_(-5.0f, -8.0f, 0.0f);
        graphics.m_280411_(texture, 0, 0, 10, 16, (float)u, (float)v, uWidth, vHeight, textureWidth, textureHeight);
        graphics.m_280168_().m_85849_();
    }

    private void renderLoadingTexture(GuiGraphics graphics, int x, int y) {
        graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, -14540254);
        graphics.m_280137_(this.f_96547_, "Loading", x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2 - 4, 0x888888);
    }

    private void renderCustomIndicator(GuiGraphics graphics, int x, int y) {
        int indicatorSize = Math.max(4, this.capeDisplaySize / 16);
        int rarityColor = -11184641;
        graphics.m_280509_(x + this.capeDisplaySize - indicatorSize * 2, y + this.capeDisplaySize - indicatorSize * 2, x + this.capeDisplaySize - indicatorSize / 2, y + this.capeDisplaySize - indicatorSize / 2, rarityColor);
    }

    private void renderAnimatedIndicator(GuiGraphics graphics, int x, int y) {
        String badgeText = "GIF";
        int textWidth = this.f_96547_.m_92895_(badgeText);
        int badgeWidth = textWidth + 4;
        Objects.requireNonNull(this.f_96547_);
        int badgeHeight = 9 + 2;
        int margin = 2;
        int badgeX = x + margin;
        int badgeY = y + margin;
        int bgColor = -805253889;
        graphics.m_280509_(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, bgColor);
        int borderColor = -16733475;
        graphics.m_280637_(badgeX, badgeY, badgeWidth, badgeHeight, borderColor);
        graphics.m_280488_(this.f_96547_, badgeText, badgeX + 2, badgeY + 1, -1);
    }

    private boolean isSelected(CapeEntry cape) {
        if (cape == null) {
            return false;
        }
        if (this.selectedCape == null) {
            return cape.isKnown() && cape.getKnownCape() != null && cape.getKnownCape().isNoCape();
        }
        return cape.getCapeId().equals(this.selectedCape.getCapeId());
    }

    private List<Component> getCapeTooltip(CapeEntry cape) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        int nameColor = cape.isKnown() ? 16766720 : 0x55FF55;
        tooltip.add((Component)Component.m_237113_((String)cape.getFriendlyName()).m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(nameColor)));
        tooltip.add((Component)Component.m_237113_((String)cape.getDescription()).m_130938_(s -> s.m_178520_(0xCCCCCC)));
        if (cape.isAnimated()) {
            tooltip.add((Component)Component.m_237113_((String)"Animated cape").m_130938_(s -> s.m_178520_(0xFFAA00)));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Static cape").m_130938_(s -> s.m_178520_(0xAAAAAA)));
        }
        if (cape.isLocal() && cape.getLocalCape() != null && cape.getLocalCape().resolution() != null) {
            String resolutionText = cape.getLocalCape().resolution().name();
            tooltip.add((Component)Component.m_237113_((String)("Resolution: " + resolutionText)).m_130938_(s -> s.m_178520_(0x55FFFF)));
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237113_((String)"Click to preview").m_130938_(s -> s.m_178520_(0x808080).m_131155_(Boolean.valueOf(true))));
        return tooltip;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        CapeEntry clickedCape;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.maxScroll > 0) {
            int scrollbarWidth = this.scaleValue(6);
            int scrollbarX = this.gridX + this.gridWidth + 3;
            int scrollbarTrackHeight = this.gridHeight;
            if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)this.gridY && mouseY < (double)(this.gridY + scrollbarTrackHeight)) {
                this.isDraggingScrollbar = true;
                int thumbHeight = Mth.m_14045_((int)((int)((float)(scrollbarTrackHeight * scrollbarTrackHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(scrollbarTrackHeight - 8));
                int thumbY = this.gridY + (int)(this.scrollOffset * (double)(scrollbarTrackHeight - thumbHeight) / (double)this.maxScroll);
                if (mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight)) {
                    this.scrollbarClickOffset = mouseY - (double)thumbY;
                } else {
                    this.scrollbarClickOffset = (double)thumbHeight / 2.0;
                    this.updateScrollFromMouse(mouseY);
                }
                return true;
            }
        }
        if (button == 0 && this.isMouseOverGrid((int)mouseX, (int)mouseY) && (clickedCape = this.getCapeAt((int)mouseX, (int)mouseY)) != null) {
            int y;
            int deleteButtonY;
            int margin;
            int x;
            int deleteButtonX;
            int[] pos;
            if (clickedCape.isLocal() && !clickedCape.isKnown() && (pos = this.getCapePosition(clickedCape)) != null && this.isMouseOver((int)mouseX, (int)mouseY, deleteButtonX = (x = pos[0]) + this.capeDisplaySize - 11 - (margin = 2), deleteButtonY = (y = pos[1]) + margin, 11, 11)) {
                this.showDeleteConfirmation(clickedCape);
                return true;
            }
            if (this.f_96541_ != null && this.f_96541_.m_91106_() != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.25f));
            }
            this.selectedCape = clickedCape;
            if (clickedCape.isKnown() && clickedCape.getKnownCape() != null && clickedCape.getKnownCape().isNoCape()) {
                this.removeCape();
            } else {
                this.applyCape(clickedCape);
            }
            return true;
        }
        return false;
    }

    private void applyCape(CapeEntry cape) {
        String capeId = cape.getCapeId();
        ClientConfig config = ClientConfig.getInstance();
        ResourceLocation capeLocation = CapeService.getInstance().getCapeLocation(null, capeId);
        if (capeLocation == null) {
            capeLocation = cape.getTextureLocation();
        }
        QuickSkin.LOGGER.info("[PlayerCapeMenuScreen] Setting cape in preview widget: {}", (Object)capeLocation);
        this.playerWidget.setCape(capeLocation, capeId);
        config.activeCapeHash = capeId;
        config.save();
        QuickSkin.LOGGER.info("Saved cape to config: {}", (Object)capeId);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            PlayerAppearanceService.getInstance().applyCape(this.f_96541_.f_91074_.m_20148_(), capeId);
            QuickSkin.LOGGER.info("Applied cape to in-game player: {}", (Object)cape.getFriendlyName());
        } else {
            UUID dummyUUID = this.getDummyPlayerUUID();
            if (dummyUUID != null) {
                PlayerAppearanceService.getInstance().applyCape(dummyUUID, capeId);
                QuickSkin.LOGGER.info("Applied cape to cached player for preview: {}", (Object)cape.getFriendlyName());
            } else {
                QuickSkin.LOGGER.info("Applied cape to preview only (no cached player): {}", (Object)cape.getFriendlyName());
            }
        }
        this.updateSpeedSliderVisibility();
    }

    private UUID getDummyPlayerUUID() {
        try {
            Field cachedPlayerField = PlayerModelRenderer.class.getDeclaredField("cachedPlayer");
            cachedPlayerField.setAccessible(true);
            Player cachedPlayer = (Player)cachedPlayerField.get(null);
            return cachedPlayer != null ? cachedPlayer.m_20148_() : null;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to get cached player UUID", (Throwable)e);
            return null;
        }
    }

    private void updateScrollFromMouse(double mouseY) {
        int scrollbarTrackHeight = this.gridHeight;
        int thumbHeight = Mth.m_14045_((int)((int)((float)(scrollbarTrackHeight * scrollbarTrackHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(scrollbarTrackHeight - 8));
        double scrollableTrackHeight = scrollbarTrackHeight - thumbHeight;
        if (scrollableTrackHeight > 0.0) {
            double scrollRatio = (mouseY - (double)this.gridY - this.scrollbarClickOffset) / scrollableTrackHeight;
            this.targetScrollOffset = Mth.m_14008_((double)(scrollRatio * (double)this.maxScroll), (double)0.0, (double)this.maxScroll);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isMouseOverGrid((int)mouseX, (int)mouseY)) {
            this.targetScrollOffset = Mth.m_14008_((double)(this.targetScrollOffset - delta * (double)this.scrollSpeed), (double)0.0, (double)this.maxScroll);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void renderScrollbar(GuiGraphics graphics) {
        if (this.maxScroll <= 0) {
            return;
        }
        int scrollbarWidth = this.scaleValue(6);
        int scrollbarX = this.gridX + this.gridWidth + 3;
        int scrollbarTrackEnd = this.gridY + this.gridHeight;
        graphics.m_280509_(scrollbarX, this.gridY, scrollbarX + scrollbarWidth, scrollbarTrackEnd, Integer.MIN_VALUE);
        int thumbHeight = Mth.m_14045_((int)((int)((float)(this.gridHeight * this.gridHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(this.gridHeight - 8));
        int thumbY = this.gridY + (int)(this.scrollOffset * (double)(this.gridHeight - thumbHeight) / (double)this.maxScroll);
        graphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -8355712);
        graphics.m_280509_(scrollbarX + 1, thumbY + 1, scrollbarX + scrollbarWidth - 1, thumbY + thumbHeight - 1, -4144960);
    }

    @Nullable
    private CapeEntry getCapeAt(int mouseX, int mouseY) {
        int sectionHeight;
        int rows;
        if (!this.isMouseOverGrid(mouseX, mouseY)) {
            return null;
        }
        int absoluteMouseY = mouseY + (int)this.scrollOffset;
        int currentY = this.gridY;
        if (!this.localCapes.isEmpty()) {
            CapeEntry cape;
            rows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            sectionHeight = rows * (this.capeDisplaySize + this.capePadding) + this.capePadding;
            if (absoluteMouseY >= (currentY += 20) && absoluteMouseY < currentY + sectionHeight && (cape = this.findCapeInGrid(mouseX, mouseY, absoluteMouseY, currentY, this.localCapes)) != null) {
                return cape;
            }
            currentY += sectionHeight;
        }
        if (!this.knownCapes.isEmpty()) {
            currentY += 20;
            rows = (int)Math.ceil((double)this.knownCapes.size() / (double)this.capesPerRow);
            sectionHeight = rows * (this.capeDisplaySize + this.capePadding) + this.capePadding;
            if (absoluteMouseY >= (currentY += 20) && absoluteMouseY < currentY + sectionHeight) {
                return this.findCapeInGrid(mouseX, mouseY, absoluteMouseY, currentY, this.knownCapes);
            }
        }
        return null;
    }

    private CapeEntry findCapeInGrid(int mouseX, int mouseY, int absoluteMouseY, int sectionTopY, List<CapeEntry> capes) {
        int capeY;
        int capeX;
        int relX = mouseX - this.gridX - this.capePadding;
        int relY = absoluteMouseY - sectionTopY - this.capePadding;
        int col = relX / (this.capeDisplaySize + this.capePadding);
        int row = relY / (this.capeDisplaySize + this.capePadding);
        if (col < 0 || col >= this.capesPerRow) {
            return null;
        }
        int index = row * this.capesPerRow + col;
        if (index >= 0 && index < capes.size() && this.isMouseOver(mouseX, mouseY, capeX = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding), capeY = sectionTopY + this.capePadding + row * (this.capeDisplaySize + this.capePadding) - (int)this.scrollOffset, this.capeDisplaySize, this.capeDisplaySize)) {
            return capes.get(index);
        }
        return null;
    }

    @Nullable
    private int[] getCapePosition(CapeEntry cape) {
        int index;
        int currentY = this.gridY - (int)this.scrollOffset;
        if (!this.localCapes.isEmpty()) {
            currentY += 20;
            index = this.localCapes.indexOf(cape);
            if (index != -1) {
                int row = index / this.capesPerRow;
                int col = index % this.capesPerRow;
                int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
                int y = currentY + this.capePadding + row * (this.capeDisplaySize + this.capePadding);
                return new int[]{x, y};
            }
            int rows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            currentY += rows * (this.capeDisplaySize + this.capePadding);
        }
        if (!this.knownCapes.isEmpty()) {
            currentY += 20;
            currentY += 20;
            index = this.knownCapes.indexOf(cape);
            if (index != -1) {
                int row = index / this.capesPerRow;
                int col = index % this.capesPerRow;
                int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
                int y = currentY + this.capePadding + row * (this.capeDisplaySize + this.capePadding);
                return new int[]{x, y};
            }
        }
        return null;
    }

    private boolean isMouseOverGrid(int mouseX, int mouseY) {
        return mouseX >= this.gridX && mouseX < this.gridX + this.gridWidth && mouseY >= this.gridY && mouseY < this.gridY + this.gridHeight;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public void m_7400_(List<Path> paths) {
        List<Path> validFiles = paths.stream().filter(p -> {
            String name = p.toString().toLowerCase();
            return name.endsWith(".png") || name.endsWith(".gif");
        }).toList();
        if (validFiles.isEmpty()) {
            this.showImportMessage("No PNG or GIF files found", 0xFFAA00, 100);
            return;
        }
        this.showImportMessage("Processing " + validFiles.size() + " file(s)...", 0x55AAFF, 60);
        CompletableFuture.runAsync(() -> {
            int successCount = 0;
            int invalidCount = 0;
            Path capesDir = LocalAssetManager.getInstance().getCapesDirectory();
            try {
                Files.createDirectories(capesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Minecraft.m_91087_().execute(() -> this.showImportMessage("Error: Could not create capes directory", 0xFF5555, 100));
                return;
            }
            for (Path file : validFiles) {
                if (this.processDroppedFile(file, capesDir)) {
                    ++successCount;
                    continue;
                }
                ++invalidCount;
            }
            int finalSuccessCount = successCount;
            int finalInvalidCount = invalidCount;
            Minecraft.m_91087_().execute(() -> {
                if (finalSuccessCount > 0) {
                    LocalAssetManager.getInstance().reload();
                    this.refreshCapeList();
                    this.updateGridDimensions();
                    Object message = String.format("\u2713 Imported %d cape%s", finalSuccessCount, finalSuccessCount == 1 ? "" : "s");
                    if (finalInvalidCount > 0) {
                        message = (String)message + String.format(" (%d invalid)", finalInvalidCount);
                    }
                    this.showImportMessage((String)message, finalSuccessCount > finalInvalidCount ? 0x55FF55 : 0xFFAA00, 200);
                } else {
                    this.showImportMessage("\u26a0 No valid capes found (must be 2:1 ratio or animation strip)", 0xFF5555, 200);
                }
            });
        }).exceptionally(throwable -> {
            Minecraft.m_91087_().execute(() -> this.showImportMessage("Error processing files: " + throwable.getMessage(), 0xFF5555, 200));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean processDroppedFile(Path sourceFile, Path targetDir) {
        try {
            String hash;
            byte[] finalAtlasBytes;
            BufferedImage finalAtlas;
            boolean isStandardFormat;
            int i;
            BufferedImage sourceAtlas;
            AnimationMetadata animationMetadata;
            int frameCount;
            block33: {
                SkinResolution frameRes;
                String lowerCaseName = sourceFile.toString().toLowerCase();
                boolean isGif = lowerCaseName.endsWith(".gif");
                frameCount = 1;
                animationMetadata = null;
                if (isGif) {
                    try (InputStream is = Files.newInputStream(sourceFile, new OpenOption[0]);){
                        StbGifLoader.GifLoadResult gifResult = StbGifLoader.loadGif(is);
                        if (gifResult == null || gifResult.frames() == null) {
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            int width = gifResult.frameWidth();
                            int height = gifResult.frameHeight();
                            frameCount = gifResult.frames().length;
                            int atlasHeight = height * frameCount;
                            sourceAtlas = new BufferedImage(width, atlasHeight, 2);
                            for (i = 0; i < frameCount; ++i) {
                                NativeImage frame = gifResult.frames()[i];
                                for (int y = 0; y < height; ++y) {
                                    for (int x = 0; x < width; ++x) {
                                        int abgr = frame.m_84985_(x, y);
                                        int a = abgr >> 24 & 0xFF;
                                        int b = abgr >> 16 & 0xFF;
                                        int g = abgr >> 8 & 0xFF;
                                        int r = abgr & 0xFF;
                                        int argb = a << 24 | r << 16 | g << 8 | b;
                                        sourceAtlas.setRGB(x, i * height + y, argb);
                                    }
                                }
                            }
                            animationMetadata = gifResult.metadata();
                            isStandardFormat = true;
                            break block33;
                        }
                        finally {
                            gifResult.close();
                        }
                    }
                }
                BufferedImage image = ImageIO.read(sourceFile.toFile());
                if (image == null) {
                    return false;
                }
                sourceAtlas = image;
                int w = image.getWidth();
                int h = image.getHeight();
                int frameHeightIfCape = w / 2;
                isStandardFormat = false;
                if (w > 0 && h > 0 && w % 2 == 0 && h % frameHeightIfCape == 0 && (frameRes = SkinResolution.fromDimensions(w, frameHeightIfCape)) != null) {
                    isStandardFormat = true;
                    frameCount = h / frameHeightIfCape;
                }
            }
            if (isStandardFormat) {
                QuickSkin.LOGGER.info("Processing as a standard cape format ({} frames): {}", (Object)frameCount, (Object)sourceFile.getFileName());
                BufferedImage normalizedAtlas = HDTextureProcessor.resizeAnimationStrip(sourceAtlas, 64);
                if (this.isElytraAreaTransparent(normalizedAtlas)) {
                    QuickSkin.LOGGER.info("Detected transparent elytra. Compositing with vanilla elytra.");
                    BufferedImage vanillaElytraBase = this.getVanillaElytraImage();
                    if (vanillaElytraBase == null) {
                        finalAtlas = normalizedAtlas;
                    } else {
                        BufferedImage compositeAtlas = new BufferedImage(normalizedAtlas.getWidth(), normalizedAtlas.getHeight(), 2);
                        Graphics2D g = compositeAtlas.createGraphics();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(0, 0, normalizedAtlas.getWidth(), normalizedAtlas.getHeight());
                        g.setComposite(AlphaComposite.SrcOver);
                        for (i = 0; i < frameCount; ++i) {
                            int yOffset = i * 32;
                            g.drawImage((Image)vanillaElytraBase, 0, yOffset, null);
                            g.drawImage((Image)normalizedAtlas.getSubimage(0, yOffset, 64, 32), 0, yOffset, null);
                        }
                        g.dispose();
                        finalAtlas = compositeAtlas;
                    }
                } else {
                    finalAtlas = normalizedAtlas;
                }
            } else {
                QuickSkin.LOGGER.info("Processing non-standard image as a custom static cape: {}", (Object)sourceFile.getFileName());
                BufferedImage vanillaElytraBase = this.getVanillaElytraImage();
                if (vanillaElytraBase == null) {
                    vanillaElytraBase = new BufferedImage(64, 32, 2);
                }
                BufferedImage newCapeTexture = new BufferedImage(64, 32, 2);
                Graphics2D g = newCapeTexture.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, 64, 32);
                g.setComposite(AlphaComposite.SrcOver);
                g.drawImage((Image)vanillaElytraBase, 0, 0, null);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.drawImage(sourceAtlas, 0, 0, 22, 17, null);
                g.dispose();
                finalAtlas = newCapeTexture;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)finalAtlas, "png", baos);
                finalAtlasBytes = baos.toByteArray();
            }
            if (animationMetadata != null && (hash = HashUtil.computeHash(finalAtlasBytes)) != null) {
                Path metadataPath = LocalAssetManager.getInstance().getCacheDirectory().resolve(hash + ".json");
                Files.writeString(metadataPath, (CharSequence)animationMetadata.toJson(), new OpenOption[0]);
                QuickSkin.LOGGER.info("Saved animation metadata for imported GIF: {}", (Object)metadataPath);
            }
            Path targetPath = this.resolveTargetPath(sourceFile, targetDir);
            this.saveImageWithAlpha(finalAtlas, targetPath);
            return true;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Error processing dropped file {}: {}", (Object)sourceFile.getFileName(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean isElytraAreaTransparent(BufferedImage image) {
        double scale = (double)image.getWidth() / 64.0;
        int elytraX = (int)(22.0 * scale);
        int elytraY = 0;
        int elytraWidth = (int)(32.0 * scale);
        int elytraHeight = (int)(16.0 * scale);
        int samplePoints = 5;
        for (int i = 0; i < samplePoints; ++i) {
            for (int j = 0; j < samplePoints; ++j) {
                int x = elytraX + i * elytraWidth / (samplePoints - 1);
                int y = elytraY + j * elytraHeight / (samplePoints - 1);
                int pixel = image.getRGB(x = Math.min(x, image.getWidth() - 1), y = Math.min(y, image.getHeight() - 1));
                int alpha = pixel >> 24 & 0xFF;
                if (alpha <= 10) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private BufferedImage getVanillaElytraImage() {
        try {
            ResourceLocation VANILLA_ELYTRA_TEXTURE = new ResourceLocation("minecraft", "textures/entity/elytra.png");
            Optional resourceOptional = Minecraft.m_91087_().m_91098_().m_213713_(VANILLA_ELYTRA_TEXTURE);
            if (resourceOptional.isEmpty()) {
                QuickSkin.LOGGER.error("Vanilla elytra texture resource not found");
                return null;
            }
            InputStream stream = ((Resource)resourceOptional.get()).m_215507_();
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            return image;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load vanilla elytra texture for custom cape creation", (Throwable)e);
            return null;
        }
    }

    private Path resolveTargetPath(Path sourceFile, Path targetDir) {
        String fileName = sourceFile.getFileName().toString();
        String nameWithoutExt = fileName.substring(0, fileName.lastIndexOf(46));
        String ext = ".png";
        Path targetPath = targetDir.resolve(nameWithoutExt + ext);
        int counter = 1;
        while (Files.exists(targetPath, new LinkOption[0])) {
            targetPath = targetDir.resolve(nameWithoutExt + "_" + counter + ext);
            ++counter;
        }
        return targetPath;
    }

    private void saveImageWithAlpha(BufferedImage image, Path outputPath) throws IOException {
        BufferedImage argbImage;
        if (image.getType() != 2) {
            argbImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = argbImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        } else {
            argbImage = image;
        }
        ImageIO.write((RenderedImage)argbImage, "png", outputPath.toFile());
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.unregisterAllAnimations();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void unregisterAllAnimations() {
        String animationId;
        String capeId;
        AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
        for (CapeEntry cape : this.localCapes) {
            if (!cape.isAnimated()) continue;
            capeId = cape.getCapeId();
            animationId = null;
            if (capeId.startsWith("local_cape:")) {
                animationId = "cape_" + capeId.substring("local_cape:".length());
            }
            if (animationId == null) continue;
            animManager.unregisterAnimation(animationId);
            QuickSkin.LOGGER.debug("[PlayerCapeMenuScreen] Unregistered animation on close: {}", (Object)animationId);
        }
        for (CapeEntry cape : this.knownCapes) {
            if (!cape.isAnimated()) continue;
            capeId = cape.getCapeId();
            animationId = null;
            if (capeId.startsWith("known:")) {
                animationId = "cape_known_" + capeId.substring("known:".length());
            }
            if (animationId == null) continue;
            animManager.unregisterAnimation(animationId);
            QuickSkin.LOGGER.debug("[PlayerCapeMenuScreen] Unregistered animation on close: {}", (Object)animationId);
        }
    }

    private class SpeedSlider
    extends AbstractSliderButton {
        final double minSpeed = 0.1;
        final double maxSpeed = 3.0;

        public SpeedSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.minSpeed = 0.1;
            this.maxSpeed = 3.0;
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Controls animation speed for this cape (10% - 300%)")));
            this.loadSpeedForCurrentCape();
        }

        public void loadSpeedForCurrentCape() {
            if (PlayerCapeMenuScreen.this.selectedCape == null || !PlayerCapeMenuScreen.this.selectedCape.isAnimated()) {
                this.f_93577_ = 0.5;
                this.m_5695_();
                return;
            }
            String capeId = PlayerCapeMenuScreen.this.selectedCape.getCapeId();
            double currentSpeed = ClientConfig.getInstance().getCapeAnimationSpeed(capeId);
            double clampedSpeed = Mth.m_14008_((double)currentSpeed, (double)0.1, (double)3.0);
            this.f_93577_ = Math.sqrt((clampedSpeed - 0.1) / 2.9);
            this.m_5695_();
        }

        protected void m_5695_() {
            int percentage = (int)Math.round(10.0 + this.f_93577_ * this.f_93577_ * 290.0);
            this.m_93666_((Component)Component.m_237113_((String)String.format("Animation Speed: %d%%", percentage)));
        }

        protected void m_5697_() {
            if (PlayerCapeMenuScreen.this.selectedCape == null || !PlayerCapeMenuScreen.this.selectedCape.isAnimated()) {
                return;
            }
            double v = this.f_93577_;
            double speed = 0.1 + v * v * 2.9;
            speed = Math.max(0.01, Math.min(speed, 10.0));
            String capeId = PlayerCapeMenuScreen.this.selectedCape.getCapeId();
            ClientConfig.getInstance().setCapeAnimationSpeed(capeId, (float)speed);
            String animationId = this.getAnimationIdForCape(capeId);
            if (animationId != null) {
                AnimatedTextureManager.getInstance().setAnimationSpeed(animationId, (float)speed);
            }
        }

        public void m_7691_(double mouseX, double mouseY) {
            super.m_7691_(mouseX, mouseY);
            ClientConfig.getInstance().save();
            if (PlayerCapeMenuScreen.this.selectedCape != null) {
                float speed = ClientConfig.getInstance().getCapeAnimationSpeed(PlayerCapeMenuScreen.this.selectedCape.getCapeId());
                QuickSkin.LOGGER.info("Saved animation speed for {}: {}x", (Object)PlayerCapeMenuScreen.this.selectedCape.getCapeId(), (Object)Float.valueOf(speed));
            }
        }

        private String getAnimationIdForCape(String capeId) {
            if (capeId == null) {
                return null;
            }
            if (capeId.startsWith("local_cape:")) {
                String hash = capeId.substring("local_cape:".length());
                return "cape_" + hash;
            }
            if (capeId.startsWith("known:")) {
                String knownId = capeId.substring("known:".length());
                return "cape_known_" + knownId;
            }
            return null;
        }
    }
}

