/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.rendering;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.quickskin.mod.QuickSkin;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class SkinLayers3DIntegration {
    private static final Map<ResourceLocation, PlayerMeshes> meshCache = new HashMap<ResourceLocation, PlayerMeshes>();
    private static boolean MOD_AVAILABLE;
    private static Object configInstance;
    private static Object meshHelperInstance;
    private static Method create3DMeshMethod;
    private static Method meshRenderMethod;
    private static Method meshSetPositionMethod;
    private static Field headVoxelSizeField;
    private static Field bodyVoxelWidthSizeField;
    private static Field baseVoxelSizeField;
    private static Field enableHatField;
    private static Field enableJacketField;
    private static Field enableLeftSleeveField;
    private static Field enableRightSleeveField;
    private static Field enableLeftPantsField;
    private static Field enableRightPantsField;

    public static boolean isAvailable() {
        return MOD_AVAILABLE;
    }

    public static void render3DLayers(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, PlayerModel<?> model, ResourceLocation skinLocation, boolean thinArms) {
        if (!MOD_AVAILABLE) {
            return;
        }
        try {
            PlayerMeshes meshes = SkinLayers3DIntegration.getOrCreateMeshes(skinLocation, thinArms);
            if (meshes == null || !meshes.isValid()) {
                return;
            }
            VertexConsumer vertices = bufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)skinLocation, (boolean)true));
            if (SkinLayers3DIntegration.getBooleanConfig(enableHatField) && meshes.headMesh != null) {
                SkinLayers3DIntegration.renderHeadLayer(poseStack, vertices, light, overlay, model, meshes.headMesh);
            }
            if (SkinLayers3DIntegration.getBooleanConfig(enableJacketField) && meshes.torsoMesh != null) {
                SkinLayers3DIntegration.renderBodyLayer(poseStack, vertices, light, overlay, model, meshes.torsoMesh);
            }
            if (SkinLayers3DIntegration.getBooleanConfig(enableLeftSleeveField) && meshes.leftArmMesh != null) {
                SkinLayers3DIntegration.renderArmLayer(poseStack, vertices, light, overlay, model.f_102812_, meshes.leftArmMesh, false, thinArms);
            }
            if (SkinLayers3DIntegration.getBooleanConfig(enableRightSleeveField) && meshes.rightArmMesh != null) {
                SkinLayers3DIntegration.renderArmLayer(poseStack, vertices, light, overlay, model.f_102811_, meshes.rightArmMesh, true, thinArms);
            }
            if (SkinLayers3DIntegration.getBooleanConfig(enableLeftPantsField) && meshes.leftLegMesh != null) {
                SkinLayers3DIntegration.renderLegLayer(poseStack, vertices, light, overlay, model.f_102814_, meshes.leftLegMesh);
            }
            if (SkinLayers3DIntegration.getBooleanConfig(enableRightPantsField) && meshes.rightLegMesh != null) {
                SkinLayers3DIntegration.renderLegLayer(poseStack, vertices, light, overlay, model.f_102813_, meshes.rightLegMesh);
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("[3D Skin Layers] Error rendering layers: {}", (Object)e.getMessage());
        }
    }

    private static PlayerMeshes getOrCreateMeshes(ResourceLocation skinLocation, boolean thinArms) {
        PlayerMeshes cached = meshCache.get(skinLocation);
        if (cached != null && cached.isValid()) {
            return cached;
        }
        try {
            NativeImage skin = SkinLayers3DIntegration.getSkinTexture(skinLocation);
            if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
                return null;
            }
            PlayerMeshes meshes = new PlayerMeshes();
            meshes.headMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 8, 8, 8, 32, 0, false, Float.valueOf(0.6f));
            meshes.torsoMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 8, 12, 4, 16, 32, true, Float.valueOf(0.0f));
            meshes.leftLegMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 4, 12, 4, 0, 48, true, Float.valueOf(0.0f));
            meshes.rightLegMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 4, 12, 4, 0, 32, true, Float.valueOf(0.0f));
            if (thinArms) {
                meshes.leftArmMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 3, 12, 4, 48, 48, true, Float.valueOf(-2.0f));
                meshes.rightArmMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 3, 12, 4, 40, 32, true, Float.valueOf(-2.0f));
            } else {
                meshes.leftArmMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 4, 12, 4, 48, 48, true, Float.valueOf(-2.0f));
                meshes.rightArmMesh = create3DMeshMethod.invoke(meshHelperInstance, skin, 4, 12, 4, 40, 32, true, Float.valueOf(-2.0f));
            }
            if (meshes.isValid()) {
                meshCache.put(skinLocation, meshes);
                return meshes;
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("[3D Skin Layers] Failed to create meshes: {}", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    private static NativeImage getSkinTexture(ResourceLocation skinLocation) {
        block8: {
            try {
                Minecraft mc = Minecraft.m_91087_();
                Optional optionalRes = mc.m_91098_().m_213713_(skinLocation);
                if (optionalRes.isPresent()) {
                    return NativeImage.m_85058_((InputStream)((Resource)optionalRes.get()).m_215507_());
                }
                AbstractTexture texture = mc.m_91097_().m_118506_(skinLocation);
                if (texture instanceof DynamicTexture) {
                    NativeImage pixels = ((DynamicTexture)texture).m_117991_();
                    if (pixels != null) {
                        return pixels;
                    }
                    break block8;
                }
                if (!(texture instanceof HttpTexture)) break block8;
                try {
                    Field fileField = HttpTexture.class.getDeclaredField("file");
                    fileField.setAccessible(true);
                    File file = (File)fileField.get(texture);
                    if (file != null && file.isFile()) {
                        return NativeImage.m_85058_((InputStream)new FileInputStream(file));
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private static void renderHeadLayer(PoseStack poseStack, VertexConsumer vertices, int light, int overlay, PlayerModel<?> model, Object headMesh) {
        try {
            float voxelSize = SkinLayers3DIntegration.getFloatConfig(headVoxelSizeField);
            poseStack.m_85836_();
            model.f_102808_.m_104299_(poseStack);
            poseStack.m_85837_(0.0, -0.25, 0.0);
            poseStack.m_85841_(voxelSize, voxelSize, voxelSize);
            poseStack.m_85837_(0.0, 0.25, 0.0);
            poseStack.m_85837_(0.0, -0.04, 0.0);
            meshRenderMethod.invoke(headMesh, model.f_102808_, poseStack, vertices, light, overlay, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderBodyLayer(PoseStack poseStack, VertexConsumer vertices, int light, int overlay, PlayerModel<?> model, Object torsoMesh) {
        try {
            float widthScaling = SkinLayers3DIntegration.getFloatConfig(bodyVoxelWidthSizeField);
            float heightScaling = 1.035f;
            float pixelScaling = SkinLayers3DIntegration.getFloatConfig(baseVoxelSizeField);
            poseStack.m_85836_();
            model.f_102810_.m_104299_(poseStack);
            poseStack.m_85841_(widthScaling, heightScaling, pixelScaling);
            meshSetPositionMethod.invoke(torsoMesh, Float.valueOf(0.0f), Float.valueOf(-0.2f), Float.valueOf(0.0f));
            meshRenderMethod.invoke(torsoMesh, model.f_102810_, poseStack, vertices, light, overlay, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderArmLayer(PoseStack poseStack, VertexConsumer vertices, int light, int overlay, ModelPart arm, Object armMesh, boolean isRightArm, boolean thinArms) {
        try {
            float x;
            float pixelScaling = SkinLayers3DIntegration.getFloatConfig(baseVoxelSizeField);
            float heightScaling = 1.035f;
            poseStack.m_85836_();
            arm.m_104299_(poseStack);
            poseStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            float f = x = thinArms ? 0.499f : 0.998f;
            if (isRightArm) {
                x *= -1.0f;
            }
            meshSetPositionMethod.invoke(armMesh, Float.valueOf(x), Float.valueOf(-0.1f), Float.valueOf(0.0f));
            meshRenderMethod.invoke(armMesh, arm, poseStack, vertices, light, overlay, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderLegLayer(PoseStack poseStack, VertexConsumer vertices, int light, int overlay, ModelPart leg, Object legMesh) {
        try {
            float pixelScaling = SkinLayers3DIntegration.getFloatConfig(baseVoxelSizeField);
            float heightScaling = 1.035f;
            poseStack.m_85836_();
            leg.m_104299_(poseStack);
            poseStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            meshSetPositionMethod.invoke(legMesh, Float.valueOf(0.0f), Float.valueOf(-0.2f), Float.valueOf(0.0f));
            meshRenderMethod.invoke(legMesh, leg, poseStack, vertices, light, overlay, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean getBooleanConfig(Field field) {
        try {
            return field.getBoolean(configInstance);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static float getFloatConfig(Field field) {
        try {
            return field.getFloat(configInstance);
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public static void clearCache() {
        meshCache.clear();
    }

    static {
        try {
            Field configField;
            Class<?> meshClass;
            Class<?> skinLayersAPIClass;
            block8: {
                Class<?> skinLayersModBaseClass = Class.forName("dev.tr7zw.skinlayers.SkinLayersModBase");
                skinLayersAPIClass = Class.forName("dev.tr7zw.skinlayers.api.SkinLayersAPI");
                meshClass = Class.forName("dev.tr7zw.skinlayers.api.Mesh");
                configField = null;
                try {
                    configField = skinLayersModBaseClass.getField("config");
                }
                catch (NoSuchFieldException e1) {
                    for (Class<?> currentClass = skinLayersModBaseClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                        try {
                            configField = currentClass.getDeclaredField("config");
                            break;
                        }
                        catch (NoSuchFieldException e2) {
                            continue;
                        }
                    }
                    if (configField != null) break block8;
                    throw new NoSuchFieldException("config field not found in class hierarchy");
                }
            }
            configField.setAccessible(true);
            configInstance = configField.get(null);
            if (configInstance == null) {
                throw new IllegalStateException("Config instance is null");
            }
            Class<?> configClass = configInstance.getClass();
            headVoxelSizeField = configClass.getDeclaredField("headVoxelSize");
            bodyVoxelWidthSizeField = configClass.getDeclaredField("bodyVoxelWidthSize");
            baseVoxelSizeField = configClass.getDeclaredField("baseVoxelSize");
            enableHatField = configClass.getDeclaredField("enableHat");
            enableJacketField = configClass.getDeclaredField("enableJacket");
            enableLeftSleeveField = configClass.getDeclaredField("enableLeftSleeve");
            enableRightSleeveField = configClass.getDeclaredField("enableRightSleeve");
            enableLeftPantsField = configClass.getDeclaredField("enableLeftPants");
            enableRightPantsField = configClass.getDeclaredField("enableRightPants");
            Method getMeshHelperMethod = skinLayersAPIClass.getDeclaredMethod("getMeshHelper", new Class[0]);
            meshHelperInstance = getMeshHelperMethod.invoke(null, new Object[0]);
            create3DMeshMethod = meshHelperInstance.getClass().getDeclaredMethod("create3DMesh", NativeImage.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Float.TYPE);
            create3DMeshMethod.setAccessible(true);
            meshRenderMethod = meshClass.getDeclaredMethod("render", ModelPart.class, PoseStack.class, VertexConsumer.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            meshRenderMethod.setAccessible(true);
            meshSetPositionMethod = meshClass.getDeclaredMethod("setPosition", Float.TYPE, Float.TYPE, Float.TYPE);
            meshSetPositionMethod.setAccessible(true);
            MOD_AVAILABLE = true;
            QuickSkin.LOGGER.info("[3D Skin Layers] Integration enabled");
        }
        catch (Exception e) {
            MOD_AVAILABLE = false;
            QuickSkin.LOGGER.debug("[3D Skin Layers] Not available: {}", (Object)e.getMessage());
        }
    }

    private static class PlayerMeshes {
        Object headMesh;
        Object torsoMesh;
        Object leftArmMesh;
        Object rightArmMesh;
        Object leftLegMesh;
        Object rightLegMesh;

        private PlayerMeshes() {
        }

        boolean isValid() {
            return this.headMesh != null && this.torsoMesh != null && this.leftArmMesh != null && this.rightArmMesh != null && this.leftLegMesh != null && this.rightLegMesh != null;
        }
    }
}

