/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.quickskin.mod.QuickSkin;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MojangApiService {
    private static MojangApiService instance;
    private static final String MOJANG_API_BASE = "https://api.mojang.com";
    private static final String SESSION_SERVER_BASE = "https://sessionserver.mojang.com";

    private MojangApiService() {
    }

    public static MojangApiService getInstance() {
        if (instance == null) {
            instance = new MojangApiService();
        }
        return instance;
    }

    public static void init() {
        MojangApiService.getInstance();
        QuickSkin.LOGGER.info("MojangApiService initialized");
    }

    public CompletableFuture<UUID> getUuidFromUsername(String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = "https://api.mojang.com/users/profiles/minecraft/" + username;
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                    String uuidString = json.get("id").getAsString();
                    String formattedUuid = uuidString.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                    QuickSkin.LOGGER.info("Found UUID for {}: {}", (Object)username, (Object)formattedUuid);
                    return UUID.fromString(formattedUuid);
                }
                if (responseCode == 204 || responseCode == 404) {
                    QuickSkin.LOGGER.warn("Player not found: {}", (Object)username);
                    return null;
                }
                QuickSkin.LOGGER.error("Unexpected response code: {}", (Object)responseCode);
                return null;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to fetch UUID for username: {}", (Object)username, (Object)e);
                return null;
            }
        });
    }

    public CompletableFuture<SkinTextureData> getSkinTextureData(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String uuidString = uuid.toString().replace("-", "");
                String urlString = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuidString;
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                    JsonObject properties = json.getAsJsonArray("properties").get(0).getAsJsonObject();
                    String texturesBase64 = properties.get("value").getAsString();
                    String texturesJson = new String(Base64.getDecoder().decode(texturesBase64), StandardCharsets.UTF_8);
                    JsonObject texturesObject = JsonParser.parseString((String)texturesJson).getAsJsonObject();
                    JsonObject textures = texturesObject.getAsJsonObject("textures");
                    if (textures.has("SKIN")) {
                        JsonObject metadata;
                        JsonObject skinObject = textures.getAsJsonObject("SKIN");
                        String skinUrl = skinObject.get("url").getAsString();
                        String modelType = "default";
                        if (skinObject.has("metadata") && (metadata = skinObject.getAsJsonObject("metadata")).has("model") && metadata.get("model").getAsString().equals("slim")) {
                            modelType = "slim";
                        }
                        QuickSkin.LOGGER.info("Found skin URL for UUID {}: {}", (Object)uuid, (Object)skinUrl);
                        return new SkinTextureData(skinUrl, modelType);
                    }
                    QuickSkin.LOGGER.warn("No skin found for UUID: {}", (Object)uuid);
                    return null;
                }
                QuickSkin.LOGGER.error("Unexpected response code: {}", (Object)responseCode);
                return null;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to fetch skin texture data for UUID: {}", (Object)uuid, (Object)e);
                return null;
            }
        });
    }

    public CompletableFuture<BufferedImage> downloadSkinImage(String skinUrl) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL(skinUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    InputStream inputStream = connection.getInputStream();
                    BufferedImage image = ImageIO.read(inputStream);
                    inputStream.close();
                    QuickSkin.LOGGER.info("Successfully downloaded skin image from: {}", (Object)skinUrl);
                    return image;
                }
                QuickSkin.LOGGER.error("Failed to download skin image, response code: {}", (Object)responseCode);
                return null;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to download skin image from: {}", (Object)skinUrl, (Object)e);
                return null;
            }
        });
    }

    public CompletableFuture<MojangSkinData> fetchSkinByUsername(String username) {
        return this.getUuidFromUsername(username).thenCompose(uuid -> {
            if (uuid == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getSkinTextureData((UUID)uuid).thenCompose(textureData -> {
                if (textureData == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.downloadSkinImage(textureData.url).thenApply(image -> {
                    if (image == null) {
                        return null;
                    }
                    return new MojangSkinData(username, (UUID)uuid, (BufferedImage)image, textureData.modelType);
                });
            });
        });
    }

    public static class SkinTextureData {
        public final String url;
        public final String modelType;

        public SkinTextureData(String url, String modelType) {
            this.url = url;
            this.modelType = modelType;
        }
    }

    public static class MojangSkinData {
        public final String username;
        public final UUID uuid;
        public final BufferedImage image;
        public final String modelType;

        public MojangSkinData(String username, UUID uuid, BufferedImage image, String modelType) {
            this.username = username;
            this.uuid = uuid;
            this.image = image;
            this.modelType = modelType;
        }
    }
}

