/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.storage;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.AnimationMetadata;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientAnimationMetadataCache {
    private static ClientAnimationMetadataCache instance;
    private final Map<String, AnimationMetadata> metadataCache = new ConcurrentHashMap<String, AnimationMetadata>();

    private ClientAnimationMetadataCache() {
    }

    public static ClientAnimationMetadataCache getInstance() {
        if (instance == null) {
            instance = new ClientAnimationMetadataCache();
        }
        return instance;
    }

    public void storeMetadata(String hash, AnimationMetadata metadata) {
        if (hash == null || metadata == null) {
            return;
        }
        this.metadataCache.put(hash, metadata);
        QuickSkin.LOGGER.debug("Cached animation metadata for: {} ({} frames)", (Object)hash, (Object)metadata.frameCount());
    }

    @Nullable
    public AnimationMetadata getMetadata(String hash) {
        return this.metadataCache.get(hash);
    }

    public void clear() {
        this.metadataCache.clear();
        QuickSkin.LOGGER.debug("Cleared client animation metadata cache");
    }

    public void remove(String hash) {
        this.metadataCache.remove(hash);
    }
}

