/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.quickskin.mod.QuickSkin;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class SkinPreferences {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, SkinPreference> preferences = new HashMap<String, SkinPreference>();

    public String getModelType(String hash) {
        SkinPreference pref = this.preferences.get(hash);
        return pref != null ? pref.modelType : "auto";
    }

    public void setModelType(String hash, String modelType) {
        this.preferences.computeIfAbsent((String)hash, (Function<String, SkinPreference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setModelType$0(java.lang.String ), (Ljava/lang/String;)Lcom/quickskin/mod/common/data/SkinPreferences$SkinPreference;)()).modelType = modelType;
    }

    public void remove(String hash) {
        this.preferences.remove(hash);
    }

    public void clear() {
        this.preferences.clear();
    }

    public static SkinPreferences load(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return new SkinPreferences();
        }
        try {
            String json = Files.readString(path);
            SkinPreferences prefs = (SkinPreferences)GSON.fromJson(json, SkinPreferences.class);
            return prefs != null ? prefs : new SkinPreferences();
        }
        catch (IOException e) {
            return new SkinPreferences();
        }
    }

    public void save(Path path) {
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson((Object)this);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            QuickSkin.LOGGER.info("Successfully saved {} skin preferences to {}", (Object)this.preferences.size(), (Object)path);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save skin preferences to {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    public int size() {
        return this.preferences.size();
    }

    private static /* synthetic */ SkinPreference lambda$setModelType$0(String k) {
        return new SkinPreference();
    }

    public static class SkinPreference {
        public String modelType = "auto";
    }
}

