/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.util;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.SkinResolution;
import com.quickskin.mod.common.data.TextureQuality;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class HDTextureProcessor {
    public static byte[] processHDSkin(InputStream input, boolean allowTransparency) {
        try {
            int height;
            BufferedImage image = ImageIO.read(input);
            if (image == null) {
                QuickSkin.LOGGER.error("Failed to read image");
                return null;
            }
            int width = image.getWidth();
            SkinResolution resolution = SkinResolution.fromDimensions(width, height = image.getHeight());
            if (resolution == null) {
                QuickSkin.LOGGER.warn("Invalid skin dimensions: {}x{}", (Object)width, (Object)height);
                return null;
            }
            if (resolution == SkinResolution.LEGACY) {
                QuickSkin.LOGGER.debug("Converting legacy skin to modern format");
                image = HDTextureProcessor.convertLegacyToModern(image);
            }
            if (!allowTransparency) {
                image = HDTextureProcessor.removeTransparency(image);
            }
            return HDTextureProcessor.imageToPng(image);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to process HD skin", (Throwable)e);
            return null;
        }
    }

    public static BufferedImage convertLegacyToModern(BufferedImage legacy) {
        int width = legacy.getWidth();
        int scale = width / 64;
        BufferedImage modern = new BufferedImage(width, width, 2);
        Graphics2D g = modern.createGraphics();
        g.drawImage((Image)legacy, 0, 0, null);
        HDTextureProcessor.convertLimbToMirror(legacy, modern, 0, 16 * scale, 16, 48 * scale, scale);
        HDTextureProcessor.convertLimbToMirror(legacy, modern, 40, 16 * scale, 32, 48 * scale, scale);
        HDTextureProcessor.clearBlackOverlays(modern, scale);
        g.dispose();
        return modern;
    }

    private static void clearBlackOverlays(BufferedImage image, int scale) {
        if (HDTextureProcessor.isOverlayAllBlack(image, 32 * scale, 0, 32 * scale, 16 * scale)) {
            QuickSkin.LOGGER.debug("Clearing all-black head overlay");
            HDTextureProcessor.clearArea(image, 32 * scale, 0, 32 * scale, 16 * scale, 0);
        }
    }

    private static boolean isOverlayAllBlack(BufferedImage image, int x, int y, int width, int height) {
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < width; ++dx) {
                if (x + dx >= image.getWidth() || y + dy >= image.getHeight()) continue;
                int pixel = image.getRGB(x + dx, y + dy);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if (red == 0 && green == 0 && blue == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static void clearArea(BufferedImage image, int x, int y, int width, int height, int color) {
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < width; ++dx) {
                if (x + dx >= image.getWidth() || y + dy >= image.getHeight()) continue;
                image.setRGB(x + dx, y + dy, color);
            }
        }
    }

    private static void convertLimbToMirror(BufferedImage src, BufferedImage dst, int srcX, int srcY, int dstX, int dstY, int scale) {
        int faceWidth = 4 * scale;
        int topHeight = 4 * scale;
        int sideHeight = 12 * scale;
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX *= scale, srcY, faceWidth, topHeight, dstX *= scale, dstY, true, false);
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX + faceWidth, srcY, faceWidth, topHeight, dstX + faceWidth, dstY, true, false);
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX, srcY + topHeight, faceWidth, sideHeight, dstX + faceWidth * 2, dstY + topHeight, true, false);
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX + faceWidth, srcY + topHeight, faceWidth, sideHeight, dstX + faceWidth, dstY + topHeight, true, false);
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX + faceWidth * 2, srcY + topHeight, faceWidth, sideHeight, dstX, dstY + topHeight, true, false);
        HDTextureProcessor.copyAreaRGBA(src, dst, srcX + faceWidth * 3, srcY + topHeight, faceWidth, sideHeight, dstX + faceWidth * 3, dstY + topHeight, true, false);
    }

    private static void copyAreaRGBA(BufferedImage src, BufferedImage dst, int srcX, int srcY, int width, int height, int dstX, int dstY, boolean mirrorX, boolean mirrorY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int targetY;
                if (srcX + x >= src.getWidth() || srcY + y >= src.getHeight()) continue;
                int pixel = src.getRGB(srcX + x, srcY + y);
                int targetX = mirrorX ? dstX + (width - 1 - x) : dstX + x;
                int n = targetY = mirrorY ? dstY + (height - 1 - y) : dstY + y;
                if (targetX >= dst.getWidth() || targetY >= dst.getHeight()) continue;
                dst.setRGB(targetX, targetY, pixel);
            }
        }
    }

    public static BufferedImage removeTransparency(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int scale = width / 64;
        BufferedImage opaque = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = image.getRGB(x, y);
                int alpha = argb >> 24 & 0xFF;
                if (HDTextureProcessor.isOverlayLayerPixel(x / scale, y / scale)) {
                    opaque.setRGB(x, y, argb);
                    continue;
                }
                if (alpha == 0) {
                    opaque.setRGB(x, y, -16777216);
                    continue;
                }
                opaque.setRGB(x, y, argb | 0xFF000000);
            }
        }
        return opaque;
    }

    private static boolean isOverlayLayerPixel(int x, int y) {
        if (x >= 32 && x < 64 && y >= 0 && y < 16) {
            return true;
        }
        if (x >= 16 && x < 40 && y >= 32 && y < 48) {
            return true;
        }
        if (x >= 40 && x < 56 && y >= 32 && y < 48) {
            return true;
        }
        if (x >= 48 && x < 64 && y >= 48 && y < 64) {
            return true;
        }
        if (x >= 0 && x < 16 && y >= 32 && y < 48) {
            return true;
        }
        return x >= 0 && x < 16 && y >= 48 && y < 64;
    }

    public static BufferedImage downsample(BufferedImage source, int targetSize) {
        int targetHeight;
        int targetWidth;
        if (source.getWidth() <= targetSize && source.getHeight() <= targetSize) {
            return source;
        }
        if (source.getWidth() > source.getHeight()) {
            targetWidth = targetSize;
            targetHeight = targetSize * source.getHeight() / source.getWidth();
        } else {
            targetHeight = targetSize;
            targetWidth = targetSize * source.getWidth() / source.getHeight();
        }
        BufferedImage downsampled = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g = downsampled.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(source, 0, 0, targetWidth, targetHeight, null);
        g.dispose();
        return downsampled;
    }

    public static BufferedImage resizeAnimationStrip(BufferedImage source, int targetWidth) {
        int originalWidth = source.getWidth();
        if (originalWidth <= 0) {
            QuickSkin.LOGGER.warn("Source image for resize has zero or negative width.");
            return source;
        }
        if (originalWidth == targetWidth) {
            return source;
        }
        int originalFrameHeight = originalWidth / 2;
        if (originalFrameHeight <= 0 || source.getHeight() % originalFrameHeight != 0) {
            QuickSkin.LOGGER.warn("Invalid cape dimensions for resizing: {}x{}", (Object)originalWidth, (Object)source.getHeight());
            return source;
        }
        int frameCount = source.getHeight() / originalFrameHeight;
        int targetFrameHeight = targetWidth / 2;
        int targetHeight = targetFrameHeight * frameCount;
        BufferedImage resizedStrip = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g = resizedStrip.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < frameCount; ++i) {
            int sx1 = 0;
            int sy1 = i * originalFrameHeight;
            int sx2 = originalWidth;
            int sy2 = sy1 + originalFrameHeight;
            int dx1 = 0;
            int dy1 = i * targetFrameHeight;
            int dx2 = targetWidth;
            int dy2 = dy1 + targetFrameHeight;
            g.drawImage(source, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        }
        g.dispose();
        return resizedStrip;
    }

    public static byte[] createThumbnail(BufferedImage source) {
        BufferedImage thumbnail = HDTextureProcessor.downsample(source, TextureQuality.THUMBNAIL.getTargetSize());
        return HDTextureProcessor.imageToPng(thumbnail);
    }

    public static byte[] createPreview(BufferedImage source) {
        BufferedImage preview = HDTextureProcessor.downsample(source, TextureQuality.PREVIEW.getTargetSize());
        return HDTextureProcessor.imageToPng(preview);
    }

    public static byte[] normalizeForVanilla(BufferedImage source) {
        BufferedImage normalized = HDTextureProcessor.downsample(source, TextureQuality.NORMALIZED.getTargetSize());
        return HDTextureProcessor.imageToPng(normalized);
    }

    public static byte[] imageToPng(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to convert image to PNG", (Throwable)e);
            return null;
        }
    }

    public static BufferedImage pngToImage(byte[] data) {
        try {
            return ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to convert PNG to image", (Throwable)e);
            return null;
        }
    }

    public static BufferedImage normalizeCape(BufferedImage cape) {
        if (cape.getWidth() == 64 && cape.getHeight() == 32) {
            return cape;
        }
        BufferedImage normalized = new BufferedImage(64, 32, 2);
        Graphics2D g = normalized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(cape, 0, 0, 64, 32, null);
        g.dispose();
        return normalized;
    }
}

