/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.overlay.SkinPreviewOverlay;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.DebugOffsetManager;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.client.gui.widget.RotateButton;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CapeService;
import com.quickskin.mod.client.services.CooldownService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.ModelService;
import com.quickskin.mod.client.services.MojangApiService;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.client.storage.LocalAppearanceStorage;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import com.quickskin.mod.client.storage.TextureChunkReceiver;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.PlayerAppearanceRepository;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.common.util.HDTextureProcessor;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.common.util.TextureAlphaDetector;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.event.CapeTransparencyEvents;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static int tickCounter = 0;
    private static PlayerWidget playerWidget;
    private static float titleScreenBodyYaw;
    private static float titleScreenTargetRotation;
    private static String sharedAnimation;
    private static Button animationToggleButton;
    private static final List<Button> animationButtons;
    private static boolean isAnimationDropdownOpen;
    private static boolean isLeftDraggingOverlay;
    private static boolean isRightDraggingOverlay;

    public static String getSharedAnimation() {
        return sharedAnimation;
    }

    public static void setSharedAnimation(String animation) {
        if (animation != null && !animation.isEmpty()) {
            sharedAnimation = animation;
        }
    }

    public static void init() {
        QuickSkin.LOGGER.info("Registering client events...");
        CapeTransparencyEvents.register();
        ClientTickEvent.CLIENT_POST.register(client -> {
            AnimatedTextureManager.getInstance().tick();
            if (!client.f_91067_.m_91600_()) {
                boolean leftMouseDown = GLFW.glfwGetMouseButton((long)client.m_91268_().m_85439_(), (int)0) == 1;
                boolean rightMouseDown = GLFW.glfwGetMouseButton((long)client.m_91268_().m_85439_(), (int)1) == 1;
                double mouseX = client.f_91067_.m_91589_() * (double)client.m_91268_().m_85445_() / (double)client.m_91268_().m_85443_();
                double mouseY = client.f_91067_.m_91594_() * (double)client.m_91268_().m_85446_() / (double)client.m_91268_().m_85444_();
                if (leftMouseDown) {
                    if (!isLeftDraggingOverlay) {
                        if (SkinPreviewOverlay.onMouseClicked(mouseX, mouseY, 0).interruptsFurtherEvaluation()) {
                            isLeftDraggingOverlay = true;
                        }
                    } else {
                        SkinPreviewOverlay.onMouseDragged(mouseX, mouseY, 0, 0.0, 0.0);
                    }
                } else if (isLeftDraggingOverlay) {
                    SkinPreviewOverlay.onMouseReleased(mouseX, mouseY, 0);
                    isLeftDraggingOverlay = false;
                }
                if (rightMouseDown) {
                    if (!isRightDraggingOverlay) {
                        if (SkinPreviewOverlay.onRightMouseClicked(mouseX, mouseY, 1).interruptsFurtherEvaluation()) {
                            isRightDraggingOverlay = true;
                        }
                    } else {
                        SkinPreviewOverlay.onMouseDragged(mouseX, mouseY, 1, 0.0, 0.0);
                    }
                } else if (isRightDraggingOverlay) {
                    SkinPreviewOverlay.onMouseReleased(mouseX, mouseY, 1);
                    isRightDraggingOverlay = false;
                }
            } else {
                if (isLeftDraggingOverlay) {
                    isLeftDraggingOverlay = false;
                }
                if (isRightDraggingOverlay) {
                    isRightDraggingOverlay = false;
                }
            }
        });
        ClientEvents.ensurePlayerOwnSkinExists();
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            QuickSkin.LOGGER.info("Local player joined world: {}", (Object)player.m_7755_().getString());
            ClientEvents.setSharedAnimation("idle");
            PlayerAppearanceRepository.getInstance().clear();
            CooldownService.getInstance().clearCooldown();
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && minecraft.m_91091_()) {
                ServerConfig serverConfig = ServerConfig.getInstance();
                ClientConfig.getInstance().applyServerOverride(serverConfig);
                QuickSkin.LOGGER.info("Applied server config override for singleplayer world");
            }
            ClientEvents.restoreSavedAppearance(player);
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            if (player != null) {
                QuickSkin.LOGGER.info("Local player quit world: {}", (Object)player.m_7755_().getString());
            } else {
                QuickSkin.LOGGER.info("Local player quit world (player was null)");
            }
            AnimatedTextureManager.getInstance().clearAnimations();
            PlayerAppearanceRepository.getInstance().clear();
            ModelService.getInstance().clearAll();
            CooldownService.getInstance().clearCooldown();
            TextureChunkReceiver.getInstance().clear();
            NetworkTextureCache.getInstance().clear();
            ClientConfig.getInstance().applyServerOverride(null);
            TextureAlphaDetector.clearCache();
            LocalAssetManager.getInstance().clearTextureCache();
            PlayerModelRenderer.clearCachedPlayer();
            if (player != null) {
                LocalAppearanceStorage.getInstance().savePlayerPreferences(player.m_20148_());
            }
            QuickSkin.LOGGER.info("Cleared server config override and texture caches on world quit");
        });
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register((oldPlayer, newPlayer) -> {
            QuickSkin.LOGGER.debug("Player respawned");
            ClientEvents.restoreSavedAppearance(newPlayer);
        });
        ClientGuiEvent.INIT_POST.register((client, screenAccess) -> {
            LocalAssetManager assetManager;
            AssetMetadata metadata;
            Screen screen = screenAccess.getScreen();
            String screenType = ClientEvents.determineScreenType(screen);
            if (screenType == null) {
                return;
            }
            QuickSkin.LOGGER.debug("Screen initialized: {} (type: {})", (Object)screen.getClass().getSimpleName(), (Object)screenType);
            int buttonX = 0;
            int buttonY = 0;
            int buttonWidth = 98;
            int buttonHeight = 20;
            int spacing = 4;
            if (screen instanceof TitleScreen) {
                TitleScreen titleScreen = (TitleScreen)screen;
                int vanillaButtonsY = titleScreen.f_96544_ / 4 + 48 + 72;
                ImageButton accessibilityButton = null;
                for (Object listener : screen.m_6702_()) {
                    ImageButton imgButton;
                    if (!(listener instanceof ImageButton) || (imgButton = (ImageButton)listener).m_252907_() != vanillaButtonsY || imgButton.m_252754_() <= titleScreen.f_96543_ / 2 || imgButton.m_5711_() != 20 || imgButton.m_93694_() != 20 || accessibilityButton != null && imgButton.m_252754_() <= accessibilityButton.m_252754_()) continue;
                    accessibilityButton = imgButton;
                }
                if (accessibilityButton != null) {
                    buttonX = accessibilityButton.m_252754_() + accessibilityButton.m_5711_() + spacing;
                    buttonY = accessibilityButton.m_252907_();
                } else {
                    buttonX = titleScreen.f_96543_ / 2 + 128;
                    buttonY = titleScreen.f_96544_ / 4 + 48 + 84;
                }
            } else if (screen instanceof PauseScreen) {
                PauseScreen pauseScreen = (PauseScreen)screen;
                Button saveAndQuitButton = null;
                int maxWidth = 0;
                for (Object listener : screen.m_6702_()) {
                    Button button2;
                    if (!(listener instanceof Button) || (button2 = (Button)listener).m_5711_() <= maxWidth) continue;
                    maxWidth = button2.m_5711_();
                }
                if (maxWidth > 0) {
                    int maxY = -1;
                    for (GuiEventListener listener : screen.m_6702_()) {
                        Button button3;
                        if (!(listener instanceof Button) || (button3 = (Button)listener).m_5711_() != maxWidth || button3.m_252907_() <= maxY) continue;
                        maxY = button3.m_252907_();
                        saveAndQuitButton = button3;
                    }
                }
                if (saveAndQuitButton != null) {
                    buttonX = saveAndQuitButton.m_252754_() + saveAndQuitButton.m_5711_() + spacing;
                    buttonY = saveAndQuitButton.m_252907_();
                } else {
                    buttonX = pauseScreen.f_96543_ - buttonWidth - spacing;
                    buttonY = spacing;
                }
            } else {
                Button referenceButton = ClientEvents.findLargestButton(screen);
                if (referenceButton != null) {
                    int targetY = referenceButton.m_252907_();
                    int rightmostX = referenceButton.m_252754_() + referenceButton.m_5711_();
                    for (GuiEventListener listener : screen.m_6702_()) {
                        AbstractWidget widget;
                        if (!(listener instanceof AbstractWidget) || (widget = (AbstractWidget)listener).m_252907_() != targetY) continue;
                        rightmostX = Math.max(rightmostX, widget.m_252754_() + widget.m_5711_());
                    }
                    buttonX = rightmostX + spacing;
                    buttonY = targetY;
                } else {
                    buttonX = screen.f_96543_ - buttonWidth - spacing;
                    buttonY = screen.f_96544_ - buttonHeight - spacing;
                }
            }
            Button changeSkinButton = Button.m_253074_((Component)Component.m_237113_((String)"Change Skin"), button -> Minecraft.m_91087_().m_91152_((Screen)new PlayerSkinMenuScreen(screen))).m_252987_(buttonX, buttonY, buttonWidth, buttonHeight).m_253136_();
            screenAccess.addRenderableWidget((AbstractWidget)changeSkinButton);
            int widgetSize = 144;
            int offsetX = DebugOffsetManager.getOffsetX(screenType);
            int offsetY = DebugOffsetManager.getOffsetY(screenType);
            int widgetX = buttonX + offsetX;
            int widgetY = buttonY + offsetY;
            ResourceLocation skinLocation = null;
            String modelType = "classic";
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientConfig config = ClientConfig.getInstance();
            if (!config.activeSkinHash.isEmpty() && (metadata = (assetManager = LocalAssetManager.getInstance()).getMetadata(config.activeSkinHash)) != null) {
                skinLocation = assetManager.getTextureLocation(config.activeSkinHash, TextureQuality.FULL);
                modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                if ("auto".equals(modelType)) {
                    modelType = metadata.skinModel();
                }
                QuickSkin.LOGGER.debug("Using saved skin for title screen widget: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelType);
            }
            if (skinLocation == null && player != null) {
                skinLocation = player.m_108560_();
                if (!config.activeSkinHash.isEmpty()) {
                    assetManager = LocalAssetManager.getInstance();
                    modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                    metadata = assetManager.getMetadata(config.activeSkinHash);
                    if ("auto".equals(modelType) && metadata != null) {
                        modelType = metadata.skinModel();
                    } else {
                        modelType = player.m_108564_();
                        if ("default".equals(modelType)) {
                            modelType = "classic";
                        }
                    }
                } else if ("auto".equals(modelType) && "default".equals(modelType = player.m_108564_())) {
                    modelType = "classic";
                }
            }
            if (skinLocation == null) {
                skinLocation = new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
                modelType = "classic";
            }
            String capeId = config.activeCapeHash;
            ResourceLocation capeLocation = null;
            if (capeId != null && !capeId.isEmpty()) {
                capeLocation = CapeService.getInstance().getCapeLocation(null, capeId);
            }
            if (playerWidget != null) {
                titleScreenBodyYaw = playerWidget.getBodyYaw();
                titleScreenTargetRotation = playerWidget.getTargetYRotation();
                String currentAnimation = playerWidget.getAnimation();
                if (currentAnimation != null && !currentAnimation.isEmpty()) {
                    ClientEvents.setSharedAnimation(currentAnimation);
                }
            }
            playerWidget = new PlayerWidget(widgetX, widgetY, widgetSize, widgetSize, skinLocation, capeLocation, capeId, modelType);
            if ("title".equals(screenType)) {
                playerWidget.setContext(PlayerWidget.WidgetContext.TITLE_SCREEN);
            } else if ("pause".equals(screenType)) {
                playerWidget.setContext(PlayerWidget.WidgetContext.PAUSE_MENU);
            }
            screenAccess.addRenderableWidget((AbstractWidget)playerWidget);
            playerWidget.setRotationState(titleScreenBodyYaw, titleScreenTargetRotation);
            String savedAnimation = ClientEvents.getSharedAnimation();
            if (savedAnimation != null && !savedAnimation.isEmpty()) {
                playerWidget.setAnimation(savedAnimation);
            }
            int rotateButtonSize = 20;
            int rotateButtonX = buttonX;
            int rotateButtonY = buttonY - rotateButtonSize - spacing;
            RotateButton rotateButton = new RotateButton(rotateButtonX, rotateButtonY, rotateButtonSize, button -> playerWidget.toggleRotation());
            screenAccess.addRenderableWidget((AbstractWidget)rotateButton);
            playerWidget.clearPriorityWidgets();
            playerWidget.addPriorityWidget((AbstractWidget)changeSkinButton);
            playerWidget.addPriorityWidget((AbstractWidget)rotateButton);
            animationButtons.clear();
            isAnimationDropdownOpen = false;
            if ("title".equals(screenType)) {
                int animToggleWidth = 20;
                int animToggleX = buttonX + buttonWidth - animToggleWidth;
                int animToggleY = rotateButtonY;
                animationToggleButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> ClientEvents.toggleAnimationDropdown()).m_252987_(animToggleX, animToggleY, animToggleWidth, rotateButtonSize).m_253136_();
                screenAccess.addRenderableWidget((AbstractWidget)animationToggleButton);
                playerWidget.addPriorityWidget((AbstractWidget)animationToggleButton);
                List<String> availableAnimations = ClientEvents.getAvailableAnimations();
                for (int i = 0; i < availableAnimations.size(); ++i) {
                    String animName = availableAnimations.get(i);
                    int index = i;
                    Button animButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {
                        if (playerWidget != null) {
                            playerWidget.setAnimation(animName);
                            ClientEvents.setSharedAnimation(animName);
                            QuickSkin.LOGGER.info("Animation {} activated: {}", (Object)(index + 1), (Object)animName);
                        }
                        ClientEvents.toggleAnimationDropdown();
                    }).m_252987_(animToggleX, animToggleY - (i + 1) * 22, animToggleWidth, rotateButtonSize).m_253136_();
                    animButton.f_93624_ = false;
                    animButton.f_93623_ = false;
                    animationButtons.add(animButton);
                    screenAccess.addRenderableWidget((AbstractWidget)animButton);
                    playerWidget.addPriorityWidget((AbstractWidget)animButton);
                }
            }
            QuickSkin.LOGGER.debug("Added 'Change Skin' button at ({}, {}) and PlayerWidget at ({}, {}) for screen type '{}'", new Object[]{buttonX, buttonY, widgetX, widgetY, screenType});
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((client, screen, mouseX, mouseY, amount) -> {
            if (!client.f_91067_.m_91600_()) {
                return SkinPreviewOverlay.onMouseScrolled(mouseX, mouseY, amount);
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((client, screen, mouseX, mouseY, button) -> {
            boolean handled;
            PlayerWidget activeWidget = PlayerWidget.getActiveInteractionWidget();
            if (activeWidget != null && activeWidget.isInteracting() && (handled = activeWidget.m_6348_(mouseX, mouseY, button))) {
                QuickSkin.LOGGER.debug("Global mouse release forwarded to PlayerWidget");
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, tickDelta) -> {
            boolean showOverlay = ClientConfig.getInstance().showSkinPreviewOverlay;
            if (showOverlay) {
                SkinPreviewOverlay.render(guiGraphics, tickDelta);
            }
        });
        QuickSkin.LOGGER.info("Client events registered");
    }

    private static String determineScreenType(Screen screen) {
        if (screen instanceof TitleScreen) {
            return "title";
        }
        if (screen instanceof PauseScreen) {
            return "pause";
        }
        return null;
    }

    private static Button findLargestButton(Screen screen) {
        Button button;
        Button largest = null;
        int maxWidth = 0;
        int maxY = -1;
        for (GuiEventListener listener : screen.m_6702_()) {
            if (!(listener instanceof Button) || (button = (Button)listener).m_5711_() <= maxWidth) continue;
            maxWidth = button.m_5711_();
        }
        if (maxWidth > 0) {
            for (GuiEventListener listener : screen.m_6702_()) {
                if (!(listener instanceof Button) || (button = (Button)listener).m_5711_() != maxWidth || button.m_252907_() <= maxY) continue;
                maxY = button.m_252907_();
                largest = button;
            }
        }
        return largest;
    }

    private static void ensurePlayerOwnSkinExists() {
        AssetMetadata existingMetadata;
        ClientConfig config = ClientConfig.getInstance();
        if (!config.enablePlayerOwnSkinSystem) {
            QuickSkin.LOGGER.info("Player's own skin system is disabled by config. Skipping download.");
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.m_91094_() == null) {
            QuickSkin.LOGGER.warn("Cannot download player skin: Minecraft user not available");
            return;
        }
        String playerName = minecraft.m_91094_().m_92546_();
        if (!config.playerOwnSkinHash.isEmpty() && (existingMetadata = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
            QuickSkin.LOGGER.info("Player's own skin already exists: {}", (Object)existingMetadata.friendlyName());
            return;
        }
        QuickSkin.LOGGER.info("Downloading player's own skin: {}", (Object)playerName);
        ((CompletableFuture)MojangApiService.getInstance().fetchSkinByUsername(playerName).thenAccept(skinData -> {
            if (minecraft != null) {
                minecraft.execute(() -> {
                    if (skinData != null) {
                        ClientEvents.handlePlayerOwnSkinFetched(skinData);
                    } else {
                        QuickSkin.LOGGER.warn("Failed to fetch player's own skin");
                    }
                });
            }
        })).exceptionally(throwable -> {
            QuickSkin.LOGGER.error("Error fetching player's own skin", throwable);
            return null;
        });
    }

    private static void handlePlayerOwnSkinFetched(MojangApiService.MojangSkinData skinData) {
        try {
            byte[] processedImageBytes;
            BufferedImage image = skinData.image;
            if (image.getHeight() == image.getWidth() / 2) {
                QuickSkin.LOGGER.info("Converting legacy 64x32 skin to modern format for: {}", (Object)skinData.username);
                image = HDTextureProcessor.convertLegacyToModern(image);
            }
            if (ClientConfig.getInstance().shouldDisableSkinTransparency()) {
                image = HDTextureProcessor.removeTransparency(image);
            }
            if ((processedImageBytes = HDTextureProcessor.imageToPng(image)) == null) {
                QuickSkin.LOGGER.error("Failed to convert processed player skin to byte array.");
                return;
            }
            String finalHash = HashUtil.computeHash(processedImageBytes);
            if (finalHash == null) {
                QuickSkin.LOGGER.error("Failed to compute hash for processed player skin.");
                return;
            }
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            AssetMetadata existingMetadata = assetManager.getMetadata(finalHash);
            if (existingMetadata == null) {
                String fileName = skinData.username + ".png";
                Path targetPath = assetManager.getSkinsDirectory().resolve(fileName);
                int counter = 1;
                while (Files.exists(targetPath, new LinkOption[0])) {
                    targetPath = assetManager.getSkinsDirectory().resolve(skinData.username + "_" + counter + ".png");
                    ++counter;
                }
                Files.write(targetPath, processedImageBytes, new OpenOption[0]);
                QuickSkin.LOGGER.info("Successfully saved player's own skin to: {}", (Object)targetPath);
                assetManager.reload();
            } else {
                QuickSkin.LOGGER.info("Player's skin already exists in list as '{}' - skipping save.", (Object)existingMetadata.friendlyName());
            }
            ClientConfig config = ClientConfig.getInstance();
            config.playerOwnSkinHash = finalHash;
            if (config.activeSkinHash.isEmpty()) {
                config.activeSkinHash = finalHash;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    AssetMetadata metadata = assetManager.getMetadata(finalHash);
                    if (metadata != null) {
                        String skinId = "local_skin:" + finalHash;
                        String modelType = assetManager.getSkinModelPreference(finalHash);
                        PlayerAppearanceService.getInstance().applySkin(player.m_20148_(), skinId, modelType);
                        QuickSkin.LOGGER.info("Auto-selected and applied player's own skin: {}", (Object)skinData.username);
                    }
                } else {
                    QuickSkin.LOGGER.info("Auto-selected player's own skin (will apply on world join): {}", (Object)skinData.username);
                }
            } else {
                QuickSkin.LOGGER.info("Active skin already set, not auto-selecting player's own skin");
            }
            config.save();
            QuickSkin.LOGGER.info("Player's own skin set: hash {}", (Object)finalHash);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error handling player's own skin", (Throwable)e);
        }
    }

    private static void restoreSavedAppearance(LocalPlayer player) {
        AssetMetadata metadata;
        ClientConfig config = ClientConfig.getInstance();
        LocalAssetManager assetManager = LocalAssetManager.getInstance();
        if (!config.activeSkinHash.isEmpty()) {
            metadata = assetManager.getMetadata(config.activeSkinHash);
            if (metadata != null) {
                String skinId = "local_skin:" + metadata.hash();
                String modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                PlayerAppearanceService.getInstance().applySkin(player.m_20148_(), skinId, modelType);
                QuickSkin.LOGGER.info("Restored saved skin: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelType);
            } else {
                QuickSkin.LOGGER.warn("Saved skin hash not found in assets: {}", (Object)config.activeSkinHash);
            }
        } else if (!config.playerOwnSkinHash.isEmpty() && (metadata = assetManager.getMetadata(config.playerOwnSkinHash)) != null) {
            config.activeSkinHash = config.playerOwnSkinHash;
            config.save();
            String skinId = "local_skin:" + metadata.hash();
            String modelType = assetManager.getSkinModelPreference(config.playerOwnSkinHash);
            if ("auto".equals(modelType)) {
                modelType = metadata.skinModel();
            }
            PlayerAppearanceService.getInstance().applySkin(player.m_20148_(), skinId, modelType);
            QuickSkin.LOGGER.info("Auto-selected and applied player's own skin: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelType);
        }
        if (!config.activeCapeHash.isEmpty()) {
            String capeId = config.activeCapeHash;
            PlayerAppearanceService.getInstance().applyCape(player.m_20148_(), capeId);
            QuickSkin.LOGGER.info("Restored saved cape: {}", (Object)capeId);
        }
    }

    public static void autoSelectPlayerOwnSkin() {
        ClientConfig config = ClientConfig.getInstance();
        if (config.activeSkinHash.isEmpty() && !config.playerOwnSkinHash.isEmpty()) {
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            AssetMetadata metadata = assetManager.getMetadata(config.playerOwnSkinHash);
            if (metadata != null) {
                config.activeSkinHash = config.playerOwnSkinHash;
                config.save();
                QuickSkin.LOGGER.info("Auto-selected player's own skin on startup: {}", (Object)metadata.friendlyName());
            } else {
                QuickSkin.LOGGER.debug("Player's own skin hash exists in config but not in assets (will be downloaded)");
            }
        } else if (!config.activeSkinHash.isEmpty()) {
            QuickSkin.LOGGER.debug("Active skin already set: {}", (Object)config.activeSkinHash);
        }
    }

    private static void toggleAnimationDropdown() {
        isAnimationDropdownOpen = !isAnimationDropdownOpen;
        ClientEvents.updateAnimationDropdownState();
    }

    private static void updateAnimationDropdownState() {
        if (animationToggleButton != null) {
            animationToggleButton.m_93666_((Component)Component.m_237113_((String)(isAnimationDropdownOpen ? "\u00d7" : ">")));
        }
        for (Button button : animationButtons) {
            button.f_93624_ = isAnimationDropdownOpen;
            button.f_93623_ = isAnimationDropdownOpen;
        }
    }

    private static List<String> getAvailableAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        animations.add("idle");
        animations.add("walk");
        animations.add("sit");
        return animations;
    }

    static {
        titleScreenBodyYaw = 20.0f;
        titleScreenTargetRotation = 20.0f;
        sharedAnimation = "idle";
        animationButtons = new ArrayList<Button>();
        isAnimationDropdownOpen = false;
        isLeftDraggingOverlay = false;
        isRightDraggingOverlay = false;
    }
}

