/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.networking.ModNetworking;
import com.quickskin.mod.networking.packets.PacketHelper;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NetworkSyncService {
    private static NetworkSyncService instance;
    private static final int MAX_CHUNK_SIZE = 30720;

    private NetworkSyncService() {
    }

    public static NetworkSyncService getInstance() {
        if (instance == null) {
            instance = new NetworkSyncService();
        }
        return instance;
    }

    public void syncAppearance(UUID playerId, String skinId, String capeId, String model) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            QuickSkin.LOGGER.warn("Cannot sync appearance to server (not connected)");
            return;
        }
        QuickSkin.LOGGER.info("Syncing appearance to server: skin={}, cape={}, model={}", new Object[]{skinId, capeId, model});
        if (skinId != null && skinId.startsWith("local_skin:")) {
            this.uploadLocalTexture(skinId, "skin");
        }
        if (capeId != null && capeId.startsWith("local_cape:")) {
            this.uploadLocalTexture(capeId, "cape");
            String hash = capeId.substring("local_cape:".length());
            this.uploadAnimationMetadata(hash);
        }
        FriendlyByteBuf buf = PacketHelper.createUpdateAppearancePacket(playerId, skinId != null ? skinId : "", capeId != null ? capeId : "", model != null ? model : "classic");
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.UPDATE_APPEARANCE, (FriendlyByteBuf)buf);
        QuickSkin.LOGGER.debug("Sent UPDATE_APPEARANCE packet to server");
    }

    private void uploadLocalTexture(String textureId, String textureType) {
        String prefix;
        String string = prefix = textureType.equals("skin") ? "local_skin:" : "local_cape:";
        if (!textureId.startsWith(prefix)) {
            QuickSkin.LOGGER.warn("Invalid texture ID format: {}", (Object)textureId);
            return;
        }
        String hash = textureId.substring(prefix.length());
        byte[] textureData = LocalAssetManager.getInstance().loadTexture(hash, TextureQuality.FULL);
        if (textureData == null) {
            QuickSkin.LOGGER.warn("Could not find texture data for hash: {}", (Object)hash);
            return;
        }
        QuickSkin.LOGGER.info("Uploading {} texture to server: {} ({} bytes)", new Object[]{textureType, hash, textureData.length});
        int totalChunks = (int)Math.ceil((double)textureData.length / 30720.0);
        for (int i = 0; i < totalChunks; ++i) {
            int offset = i * 30720;
            int length = Math.min(30720, textureData.length - offset);
            byte[] chunk = new byte[length];
            System.arraycopy(textureData, offset, chunk, 0, length);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130070_(hash);
            buf.m_130070_(textureType);
            buf.writeInt(i);
            buf.writeInt(totalChunks);
            buf.m_130087_(chunk);
            NetworkManager.sendToServer((ResourceLocation)ModNetworking.TEXTURE_CHUNK, (FriendlyByteBuf)buf);
            QuickSkin.LOGGER.debug("Sent texture chunk {}/{} for {}", new Object[]{i + 1, totalChunks, hash});
        }
    }

    private void uploadAnimationMetadata(String hash) {
        AnimationMetadata metadata = LocalAssetManager.getInstance().getAnimationMetadata(hash);
        if (metadata == null) {
            return;
        }
        QuickSkin.LOGGER.info("Uploading animation metadata for: {}", (Object)hash);
        String metadataJson = this.serializeMetadata(metadata);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(hash);
        buf.m_130070_(metadataJson);
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.UPLOAD_ANIMATION_METADATA, (FriendlyByteBuf)buf);
        QuickSkin.LOGGER.debug("Sent animation metadata for {}", (Object)hash);
    }

    private String serializeMetadata(AnimationMetadata metadata) {
        return metadata.toJson();
    }

    public void clearAppearance(UUID playerId) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            QuickSkin.LOGGER.warn("Cannot clear appearance on server (not connected)");
            return;
        }
        QuickSkin.LOGGER.info("Clearing appearance on server");
        FriendlyByteBuf buf = PacketHelper.createUpdateAppearancePacket(playerId, "", "", "classic");
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.UPDATE_APPEARANCE, (FriendlyByteBuf)buf);
    }

    public void requestTexture(UUID playerId, String textureType, String hash) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            QuickSkin.LOGGER.warn("Cannot request texture from server (not connected)");
            return;
        }
        QuickSkin.LOGGER.info("Requesting {} texture from server: {}", (Object)textureType, (Object)hash);
        FriendlyByteBuf buf = PacketHelper.createRequestTexturePacket(playerId, textureType, hash);
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.REQUEST_TEXTURE, (FriendlyByteBuf)buf);
    }
}

