/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.data;

import com.quickskin.mod.common.data.PlayerAppearance;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ServerPlayerAppearanceRepository {
    private static final ServerPlayerAppearanceRepository INSTANCE = new ServerPlayerAppearanceRepository();
    private final Map<UUID, PlayerAppearance> appearances = new ConcurrentHashMap<UUID, PlayerAppearance>();

    private ServerPlayerAppearanceRepository() {
    }

    public static ServerPlayerAppearanceRepository getInstance() {
        return INSTANCE;
    }

    @Nullable
    public PlayerAppearance getAppearance(UUID playerId) {
        return this.appearances.get(playerId);
    }

    public void setAppearance(PlayerAppearance appearance) {
        if (appearance == null || appearance.getPlayerId() == null) {
            return;
        }
        this.appearances.put(appearance.getPlayerId(), appearance);
    }

    public void updateAppearance(UUID playerId, @Nullable String skinId, @Nullable String capeId, @Nullable String model) {
        PlayerAppearance appearance = this.appearances.computeIfAbsent(playerId, id -> new PlayerAppearance((UUID)id, "", "", "classic"));
        if (skinId != null) {
            appearance.setSkinId(skinId);
        }
        if (capeId != null) {
            appearance.setCapeId(capeId);
        }
        if (model != null) {
            appearance.setModel(model);
        }
    }

    public void removeAppearance(UUID playerId) {
        this.appearances.remove(playerId);
    }

    public void clear() {
        this.appearances.clear();
    }

    public boolean hasAppearance(UUID playerId) {
        return this.appearances.containsKey(playerId);
    }
}

