/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.panel;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.event.ClientEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PlayerPreviewPanel
extends AbstractWidget {
    @Nullable
    private PlayerWidget playerWidget;
    private Button autoModelButton;
    private Button classicModelButton;
    private Button slimModelButton;
    private Button rotateButton;
    private Button animationToggleButton;
    private final List<Button> animationButtons = new ArrayList<Button>();
    private boolean isAnimationDropdownOpen = false;
    private String currentModelType = "classic";
    @Nullable
    private Consumer<String> modelTypeChangeCallback;
    @Nullable
    private AssetMetadata currentMetadata;

    public PlayerPreviewPanel(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
    }

    public void setModelTypeChangeCallback(Consumer<String> callback) {
        this.modelTypeChangeCallback = callback;
    }

    public void setCurrentModelType(String modelType) {
        this.currentModelType = modelType;
        this.updateModelButtonStates();
    }

    public void initPlayerWidget(PlayerSkinMenuScreen screen) {
        int widgetSize = Math.min(120, Math.min(this.f_93619_, this.f_93618_));
        int playerWidgetX = this.m_252754_() + 20;
        int playerWidgetY = this.m_252907_();
        this.playerWidget = new PlayerWidget(playerWidgetX, playerWidgetY, widgetSize, widgetSize, null, null, null, "classic");
        this.playerWidget.setContext(PlayerWidget.WidgetContext.SKIN_MENU);
        String savedAnimation = ClientEvents.getSharedAnimation();
        if (savedAnimation != null && !savedAnimation.isEmpty()) {
            this.playerWidget.setAnimation(savedAnimation);
        }
        screen.registerWidget(this.playerWidget);
    }

    public void initModelButtons(PlayerSkinMenuScreen screen, int modelButtonsX, int modelButtonsY, int modelButtonsTotalWidth, int componentHeight, int spacing) {
        boolean isInGame;
        int remainingWidth = modelButtonsTotalWidth - componentHeight - spacing;
        int normalModelButtonWidth = (remainingWidth - spacing) / 2;
        this.autoModelButton = ButtonFactory.createStyled(modelButtonsX, modelButtonsY, componentHeight, componentHeight, (Component)Component.m_237113_((String)"\u2728"), button -> this.setModelType("auto"));
        screen.registerWidget(this.autoModelButton);
        this.classicModelButton = ButtonFactory.createStyled(modelButtonsX + componentHeight + spacing, modelButtonsY, normalModelButtonWidth, componentHeight, (Component)Component.m_237113_((String)"Wide"), button -> this.setModelType("classic"));
        screen.registerWidget(this.classicModelButton);
        this.slimModelButton = ButtonFactory.createStyled(modelButtonsX + componentHeight + spacing + normalModelButtonWidth + spacing, modelButtonsY, normalModelButtonWidth, componentHeight, (Component)Component.m_237113_((String)"Slim"), button -> this.setModelType("slim"));
        screen.registerWidget(this.slimModelButton);
        if (this.playerWidget != null) {
            this.playerWidget.setModelButtons(this.autoModelButton, this.classicModelButton, this.slimModelButton);
            this.playerWidget.clearPriorityWidgets();
            this.playerWidget.addPriorityWidget((AbstractWidget)this.autoModelButton);
            this.playerWidget.addPriorityWidget((AbstractWidget)this.classicModelButton);
            this.playerWidget.addPriorityWidget((AbstractWidget)this.slimModelButton);
        }
        this.updateModelButtonStates();
        int rotateButtonSize = 20;
        int rotateButtonY = modelButtonsY - rotateButtonSize - spacing;
        this.rotateButton = ButtonFactory.createRotate(modelButtonsX, rotateButtonY, rotateButtonSize, b -> {
            if (this.playerWidget != null) {
                this.playerWidget.toggleRotation();
            }
        });
        this.rotateButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Rotate Preview")));
        screen.registerWidget(this.rotateButton);
        if (this.playerWidget != null) {
            this.playerWidget.addPriorityWidget((AbstractWidget)this.rotateButton);
        }
        this.animationButtons.clear();
        this.isAnimationDropdownOpen = false;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = isInGame = mc.f_91074_ != null;
        if (!isInGame) {
            int animToggleWidth = 20;
            int animToggleX = modelButtonsX + modelButtonsTotalWidth - animToggleWidth;
            this.animationToggleButton = ButtonFactory.createStyled(animToggleX, rotateButtonY, animToggleWidth, rotateButtonSize, (Component)Component.m_237113_((String)">"), button -> this.toggleAnimationDropdown());
            screen.registerWidget(this.animationToggleButton);
            if (this.playerWidget != null) {
                this.playerWidget.addPriorityWidget((AbstractWidget)this.animationToggleButton);
            }
            List<String> availableAnimations = this.getAvailableAnimations();
            for (int i = 0; i < availableAnimations.size(); ++i) {
                String animName = availableAnimations.get(i);
                int index = i;
                Button animButton = ButtonFactory.createStyled(animToggleX, rotateButtonY - (i + 1) * 22, animToggleWidth, rotateButtonSize, (Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {
                    if (this.playerWidget != null) {
                        this.playerWidget.setAnimation(animName);
                        ClientEvents.setSharedAnimation(animName);
                        QuickSkin.LOGGER.info("Animation {} activated: {}", (Object)(index + 1), (Object)animName);
                    }
                    this.toggleAnimationDropdown();
                });
                animButton.f_93624_ = false;
                animButton.f_93623_ = false;
                this.animationButtons.add(animButton);
                screen.registerWidget(animButton);
                if (this.playerWidget == null) continue;
                this.playerWidget.addPriorityWidget((AbstractWidget)animButton);
            }
        }
    }

    private void toggleAnimationDropdown() {
        this.isAnimationDropdownOpen = !this.isAnimationDropdownOpen;
        this.updateAnimationDropdownState();
    }

    private void updateAnimationDropdownState() {
        if (this.animationToggleButton != null) {
            this.animationToggleButton.m_93666_((Component)Component.m_237113_((String)(this.isAnimationDropdownOpen ? "\u00d7" : ">")));
        }
        for (Button button : this.animationButtons) {
            button.f_93624_ = this.isAnimationDropdownOpen;
            button.f_93623_ = this.isAnimationDropdownOpen;
        }
    }

    private List<String> getAvailableAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        animations.add("idle");
        animations.add("walk");
        animations.add("sit");
        return animations;
    }

    public void updateSkin(AssetMetadata metadata, ResourceLocation skinLocation) {
        if (this.playerWidget != null && metadata != null) {
            this.currentMetadata = metadata;
            this.playerWidget.setSkin(skinLocation);
            if ("auto".equals(this.currentModelType)) {
                this.playerWidget.setModelType(metadata.skinModel());
            } else {
                this.playerWidget.setModelType(this.currentModelType);
            }
        }
    }

    public void updateCape(@Nullable ResourceLocation capeLocation, @Nullable String capeId) {
        if (this.playerWidget != null) {
            this.playerWidget.setCape(capeLocation, capeId);
        }
    }

    @Nullable
    public PlayerWidget getPlayerWidget() {
        return this.playerWidget;
    }

    private void setModelType(String modelType) {
        this.currentModelType = modelType;
        QuickSkin.LOGGER.info("[PlayerPreviewPanel] setModelType called: {}, callback is null: {}", (Object)modelType, (Object)(this.modelTypeChangeCallback == null ? 1 : 0));
        if (this.playerWidget != null) {
            if ("auto".equals(modelType) && this.currentMetadata != null) {
                this.playerWidget.setModelType(this.currentMetadata.skinModel());
            } else {
                this.playerWidget.setModelType(modelType);
            }
        }
        if (this.modelTypeChangeCallback != null) {
            QuickSkin.LOGGER.info("[PlayerPreviewPanel] Calling callback for model type: {}", (Object)modelType);
            this.modelTypeChangeCallback.accept(modelType);
        } else {
            QuickSkin.LOGGER.warn("[PlayerPreviewPanel] Callback is NULL! Cannot save model preference!");
        }
        this.updateModelButtonStates();
    }

    public String getCurrentModelType() {
        return this.currentModelType;
    }

    private void updateModelButtonStates() {
        if (this.autoModelButton != null && this.classicModelButton != null && this.slimModelButton != null) {
            boolean isAuto = "auto".equalsIgnoreCase(this.currentModelType);
            boolean isSlim = "slim".equalsIgnoreCase(this.currentModelType);
            boolean isClassic = "classic".equalsIgnoreCase(this.currentModelType);
            this.autoModelButton.f_93623_ = !isAuto;
            this.classicModelButton.f_93623_ = !isClassic;
            this.slimModelButton.f_93623_ = !isSlim;
        }
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

