/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.StarPatternCache;
import com.quickskin.mod.client.gui.panel.ActionButtonsPanel;
import com.quickskin.mod.client.gui.panel.LinkButtonsPanel;
import com.quickskin.mod.client.gui.panel.PlayerPreviewPanel;
import com.quickskin.mod.client.gui.panel.SkinListPanel;
import com.quickskin.mod.client.gui.screen.DeletionConfirmScreen;
import com.quickskin.mod.client.gui.screen.PlayerCapeMenuScreen;
import com.quickskin.mod.client.gui.screen.RenameScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.util.FileDialogHelper;
import com.quickskin.mod.client.gui.util.GuiScaleManager;
import com.quickskin.mod.client.gui.util.SkinImporter;
import com.quickskin.mod.client.gui.widget.ErrorToast;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.client.gui.widget.SkinEntry;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CooldownService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.MojangApiService;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.KnownCapes;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.config.ClientConfig;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerSkinMenuScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private SkinListPanel skinListPanel;
    private PlayerPreviewPanel playerPreviewPanel;
    private ActionButtonsPanel actionButtonsPanel;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private boolean guiScaleForced = false;
    private boolean isClosing = false;
    private float savedBodyYaw = 20.0f;
    private float savedTargetRotation = 20.0f;
    private String savedModelType = null;
    private static final int MIN_PANEL_WIDTH = 340;
    private static final int MAX_PANEL_WIDTH = 600;
    private static final int MIN_PANEL_HEIGHT = 280;
    private static final ResourceLocation STAR_PATTERN_TEXTURE = new ResourceLocation("quickskin", "textures/gui/background/star_pattern.png");
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");
    private final List<ErrorToast> errorToasts = new ArrayList<ErrorToast>();
    private EditBox usernameSearchField;
    private Button searchButton;
    private boolean isSearching = false;

    public PlayerSkinMenuScreen(@Nullable Screen parent) {
        super((Component)Component.m_237113_((String)"Quick Skin"));
        this.parent = parent;
    }

    public void m_86600_() {
        super.m_86600_();
        this.updateDoneButtonState();
    }

    private void updateDoneButtonState() {
        if (this.actionButtonsPanel == null) {
            return;
        }
        Button doneButton = this.actionButtonsPanel.getDoneButton();
        if (doneButton == null) {
            return;
        }
        if (this.f_96541_ != null && this.f_96541_.m_257720_()) {
            if (!doneButton.f_93623_) {
                doneButton.f_93623_ = true;
                doneButton.m_93666_((Component)Component.m_237113_((String)"Done"));
                doneButton.m_257544_(null);
            }
            return;
        }
        long remainingSeconds = CooldownService.getInstance().getRemainingCooldownSeconds();
        if (remainingSeconds > 0L) {
            doneButton.f_93623_ = false;
            doneButton.m_93666_((Component)Component.m_237113_((String)("On Cooldown (" + remainingSeconds + "s)")));
            doneButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"You must wait before changing your skin again.")));
        } else if (!doneButton.f_93623_) {
            doneButton.f_93623_ = true;
            doneButton.m_93666_((Component)Component.m_237113_((String)"Done"));
            doneButton.m_257544_(null);
        }
    }

    protected void m_7856_() {
        if (!this.guiScaleForced && !this.isClosing) {
            this.guiScaleForced = true;
            int optimalScale = GuiScaleManager.getOptimalMenuScale();
            if (GuiScaleManager.setMenuGuiScale(optimalScale)) {
                return;
            }
        }
        super.m_7856_();
        this.m_169413_();
        if (this.playerPreviewPanel != null) {
            PlayerWidget widget = this.playerPreviewPanel.getPlayerWidget();
            if (widget != null) {
                this.savedBodyYaw = widget.getBodyYaw();
                this.savedTargetRotation = widget.getTargetYRotation();
            }
            this.savedModelType = this.playerPreviewPanel.getCurrentModelType();
        }
        this.calculatePanelDimensions();
        int scaledPadding = 6;
        int scaledSpacing = 4;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.6f);
        int rightPanelWidth = (int)((float)this.panelWidth * 0.35f);
        int componentX = this.panelX + scaledPadding;
        int yPos = this.panelY + scaledPadding + scaledComponentHeight + scaledPadding;
        int searchButtonWidth = 60;
        int searchFieldX = componentX + 4;
        int searchFieldWidth = leftPanelWidth - 4;
        this.usernameSearchField = new EditBox(this.f_96547_, searchFieldX, yPos, searchFieldWidth - searchButtonWidth - scaledSpacing, scaledComponentHeight, (Component)Component.m_237113_((String)"Search by username"));
        this.usernameSearchField.m_94167_("Enter a player's username...");
        this.usernameSearchField.m_94199_(16);
        this.usernameSearchField.m_94151_(text -> {
            this.onUsernameFieldChanged((String)text);
            if (text.isEmpty()) {
                this.usernameSearchField.m_94167_("Enter a player's username...");
            } else {
                this.usernameSearchField.m_94167_("");
            }
        });
        this.m_142416_((GuiEventListener)this.usernameSearchField);
        this.searchButton = ButtonFactory.createStyled(searchFieldX + searchFieldWidth - searchButtonWidth, yPos, searchButtonWidth, scaledComponentHeight, (Component)Component.m_237113_((String)"Search"), button -> this.searchMojangSkin());
        this.m_142416_((GuiEventListener)this.searchButton);
        this.searchButton.f_93623_ = false;
        int topSectionHeight = scaledPadding + scaledComponentHeight + scaledPadding + scaledComponentHeight + scaledSpacing + scaledSpacing;
        int bottomSectionHeight = scaledComponentHeight * 3 + scaledSpacing * 2 + scaledPadding;
        int listHeight = this.panelHeight - topSectionHeight - bottomSectionHeight;
        this.skinListPanel = new SkinListPanel(componentX, yPos += scaledComponentHeight + scaledSpacing, leftPanelWidth, listHeight, this.f_96541_, this::onSkinSelected);
        this.skinListPanel.init(this);
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        int fourButtonWidth = (fullComponentWidth - scaledSpacing * 3) / 4;
        int actionButtonsBottomY = this.panelY + this.panelHeight - scaledPadding;
        int actionPanelHeight = scaledComponentHeight * 2 + scaledSpacing;
        int modelButtonsY = actionButtonsBottomY - actionPanelHeight - scaledComponentHeight - scaledSpacing;
        int modelButtonsX = fullWidthX + (fourButtonWidth + scaledSpacing) * 3;
        int playerWidgetX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int playerWidgetY = yPos;
        int availableHeightForWidget = this.panelHeight - topSectionHeight - bottomSectionHeight;
        this.playerPreviewPanel = new PlayerPreviewPanel(playerWidgetX, playerWidgetY, rightPanelWidth, availableHeightForWidget);
        this.playerPreviewPanel.initPlayerWidget(this);
        this.playerPreviewPanel.setModelTypeChangeCallback(this::onModelTypeChanged);
        this.playerPreviewPanel.initModelButtons(this, modelButtonsX, modelButtonsY, fourButtonWidth, scaledComponentHeight, scaledSpacing);
        int bottomY = actionButtonsBottomY - scaledComponentHeight * 2 - scaledSpacing;
        ActionButtonsPanel.ActionCallbacks callbacks = new ActionButtonsPanel.ActionCallbacks(this::openImportDialog, () -> {
            if (this.f_96541_ != null) {
                this.f_96541_.f_91066_.m_231816_().m_231514_((Object)false);
                Util.m_137581_().m_137646_("https://mcskins.top/128x128/");
            }
        }, () -> {
            if (this.f_96541_ != null) {
                this.f_96541_.f_91066_.m_231816_().m_231514_((Object)false);
                Util.m_137581_().m_137646_("https://laby.net/skins?order=trending_30d");
            }
        }, () -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PlayerCapeMenuScreen(this));
            }
        }, this::m_7379_);
        this.actionButtonsPanel = new ActionButtonsPanel(fullWidthX, bottomY, fullComponentWidth, actionPanelHeight, callbacks);
        this.actionButtonsPanel.init(this, callbacks);
        int linkButtonY = this.panelY + scaledPadding;
        int linkPanelWidth = (scaledComponentHeight + scaledSpacing) * 4;
        int linkPanelX = this.panelX + this.panelWidth - linkPanelWidth - scaledPadding;
        LinkButtonsPanel linkButtonsPanel = new LinkButtonsPanel(linkPanelX, linkButtonY, linkPanelWidth, scaledComponentHeight);
        linkButtonsPanel.init(this);
        this.restoreSavedState();
    }

    private void restoreSavedState() {
        PlayerWidget widget;
        String capeId;
        ResourceLocation capeLocation;
        AssetMetadata playerOwnSkin;
        ClientConfig config = ClientConfig.getInstance();
        boolean isResizing = this.savedModelType != null;
        AssetMetadata selectedSkin = null;
        if (!config.activeSkinHash.isEmpty() && this.skinListPanel != null) {
            AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(config.activeSkinHash);
            if (metadata != null) {
                this.skinListPanel.setSelected(metadata, !isResizing);
                selectedSkin = metadata;
            }
        } else if (config.activeSkinHash.isEmpty() && !config.playerOwnSkinHash.isEmpty() && this.skinListPanel != null && (playerOwnSkin = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
            this.skinListPanel.setSelected(playerOwnSkin, !isResizing);
            selectedSkin = playerOwnSkin;
            QuickSkin.LOGGER.info("Auto-selected player's own skin in menu");
        }
        if (this.playerPreviewPanel != null && selectedSkin != null && isResizing) {
            this.playerPreviewPanel.setCurrentModelType(this.savedModelType);
            this.playerPreviewPanel.updateSkin(selectedSkin, LocalAssetManager.getInstance().getTextureLocation(selectedSkin.hash(), TextureQuality.FULL));
            this.savedModelType = null;
        }
        if (!config.activeCapeHash.isEmpty() && this.playerPreviewPanel != null && (capeLocation = this.getCapeLocationFromId(capeId = config.activeCapeHash)) != null) {
            this.registerCapeAnimationIfNeeded(capeId, capeLocation);
            this.playerPreviewPanel.updateCape(capeLocation, capeId);
        }
        if (this.playerPreviewPanel != null && (widget = this.playerPreviewPanel.getPlayerWidget()) != null) {
            widget.setRotationState(this.savedBodyYaw, this.savedTargetRotation);
        }
    }

    @Nullable
    private ResourceLocation getCapeLocationFromId(String capeId) {
        if (capeId.startsWith("local_cape:")) {
            String hash = capeId.substring("local_cape:".length());
            return LocalAssetManager.getInstance().getTextureLocation(hash, TextureQuality.FULL);
        }
        if (capeId.startsWith("known:")) {
            String id = capeId.substring("known:".length());
            KnownCapes knownCape = KnownCapes.getById(id);
            if (knownCape != null) {
                return knownCape.getTextureLocation();
            }
            QuickSkin.LOGGER.warn("Unknown cape ID: {}", (Object)id);
            return null;
        }
        return null;
    }

    private void registerCapeAnimationIfNeeded(String capeId, ResourceLocation capeLocation) {
        if (capeId.startsWith("local_cape:")) {
            BufferedImage atlasImage;
            String hash = capeId.substring("local_cape:".length());
            String animationId = "cape_" + hash;
            AnimationMetadata metadata = LocalAssetManager.getInstance().getAnimationMetadata(hash);
            if (metadata != null && metadata.frameCount() > 1 && (atlasImage = LocalAssetManager.getInstance().getSourceImage(hash)) != null) {
                QuickSkin.LOGGER.info("Registering animation for cape in skin menu: {}", (Object)animationId);
                AnimatedTextureManager.getInstance().registerAnimation(animationId, capeId, capeLocation, atlasImage, metadata);
            }
        }
    }

    private void calculatePanelDimensions() {
        int minRequiredWidth;
        int desiredWidth = (int)((float)this.f_96543_ * 0.5f);
        int desiredHeight = (int)((float)this.f_96544_ * 0.8f);
        this.panelWidth = Mth.m_14045_((int)desiredWidth, (int)340, (int)Math.min(600, this.f_96543_ - 80));
        this.panelHeight = Mth.m_14045_((int)desiredHeight, (int)280, (int)(this.f_96544_ - 80));
        int minRequiredHeight = this.calculateMinRequiredHeight();
        if (this.panelHeight < minRequiredHeight) {
            this.panelHeight = Math.min(minRequiredHeight, this.f_96544_ - 40);
        }
        if (this.panelWidth < (minRequiredWidth = this.calculateMinRequiredWidth())) {
            this.panelWidth = Math.min(minRequiredWidth, this.f_96543_ - 40);
        }
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
    }

    private int calculateMinRequiredHeight() {
        int scaledPadding = 6;
        int scaledComponentHeight = 20;
        int scaledSpacing = 4;
        return scaledPadding * 4 + scaledComponentHeight * 7 + scaledSpacing * 4 + 120;
    }

    private int calculateMinRequiredWidth() {
        int scaledPadding = 6;
        int scaledSpacing = 4;
        return 370 + scaledPadding * 3 + scaledSpacing * 2;
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        this.renderStarPattern(graphics, partialTick);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f);
        graphics.m_280398_(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.f_96541_ != null ? this.f_96541_.f_91065_.m_93079_() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        ResourceLocation cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)this.f_96543_ / (float)cacheWidth;
        float v1 = (float)this.f_96544_ / (float)cacheHeight;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cacheTexture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, (float)this.f_96544_, 0.0f).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)this.f_96543_, (float)this.f_96544_, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)this.f_96543_, 0.0f, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.panelY + 10, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderErrorToasts(graphics);
    }

    private void renderPanel(GuiGraphics graphics) {
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.isClosing) {
            this.restoreGuiScaleIfNeeded();
        }
    }

    public void m_7379_() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void restoreGuiScaleIfNeeded() {
        if (this.guiScaleForced) {
            this.guiScaleForced = false;
            GuiScaleManager.restoreOriginalGuiScale();
            QuickSkin.LOGGER.info("PlayerSkinMenuScreen - GUI scale restored");
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (PlayerModelRenderer.handleDebugMousePressed((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (PlayerModelRenderer.handleDebugMouseDragged((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (PlayerModelRenderer.handleDebugMouseReleased((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_7400_(List<Path> files) {
        QuickSkin.LOGGER.info("Files dropped: {}", (Object)files.size());
        List<Path> pngFiles = files.stream().filter(path -> path.toString().toLowerCase().endsWith(".png")).toList();
        if (pngFiles.isEmpty()) {
            QuickSkin.LOGGER.warn("No PNG files in drop");
            return;
        }
        QuickSkin.LOGGER.info("Processing {} PNG files", (Object)pngFiles.size());
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> {
                List<AssetMetadata> imported = SkinImporter.importSkins(pngFiles.toArray(new Path[0]));
                if (!imported.isEmpty()) {
                    QuickSkin.LOGGER.info("Successfully imported {} skins", (Object)imported.size());
                    this.refreshSkinList();
                    if (this.skinListPanel != null && !imported.isEmpty()) {
                        AssetMetadata firstImported = imported.get(0);
                        this.skinListPanel.setSelected(firstImported);
                    }
                }
            });
        }
    }

    public void onSkinSelected(SkinEntry entry) {
        if (this.playerPreviewPanel != null && entry != null) {
            AssetMetadata metadata = entry.getMetadata();
            ClientConfig config = ClientConfig.getInstance();
            boolean isSkinAlreadyActive = metadata.hash().equals(config.activeSkinHash);
            String modelPreference = LocalAssetManager.getInstance().getSkinModelPreference(metadata.hash());
            QuickSkin.LOGGER.info("onSkinSelected: Loading model preference for skin {}: {} (already active: {})", new Object[]{metadata.friendlyName(), modelPreference, isSkinAlreadyActive});
            this.playerPreviewPanel.setCurrentModelType(modelPreference);
            this.playerPreviewPanel.updateSkin(metadata, LocalAssetManager.getInstance().getTextureLocation(metadata.hash(), TextureQuality.FULL));
            if (!isSkinAlreadyActive) {
                config.activeSkinHash = metadata.hash();
                config.save();
                QuickSkin.LOGGER.info("Set active skin in config: {}", (Object)metadata.friendlyName());
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    String skinId = "local_skin:" + metadata.hash();
                    String modelForService = modelPreference;
                    PlayerAppearanceService.getInstance().applySkin(this.f_96541_.f_91074_.m_20148_(), skinId, modelForService);
                    QuickSkin.LOGGER.info("Applied skin to player: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelForService);
                }
            }
        }
    }

    private void onModelTypeChanged(String newModelType) {
        SkinEntry selectedEntry;
        SkinEntry skinEntry = selectedEntry = this.skinListPanel != null ? this.skinListPanel.getSelected() : null;
        if (selectedEntry != null) {
            AssetMetadata metadata = selectedEntry.getMetadata();
            String skinId = "local_skin:" + metadata.hash();
            QuickSkin.LOGGER.info("Changed model type to: {} for skin: {}", (Object)newModelType, (Object)metadata.friendlyName());
            LocalAssetManager.getInstance().setSkinModelPreference(metadata.hash(), newModelType);
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                PlayerAppearanceService.getInstance().applySkin(this.f_96541_.f_91074_.m_20148_(), skinId, newModelType);
            }
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public <T extends GuiEventListener & Renderable> void registerWidget(T widget) {
        this.m_142416_(widget);
    }

    private void openImportDialog() {
        FileDialogHelper.openSkinFileDialog("Select Skin File", this::handleSkinImport);
    }

    private void handleSkinImport(Path filePath) {
        if (filePath == null) {
            return;
        }
        QuickSkin.LOGGER.info("Importing skin: {}", (Object)filePath);
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> {
                AssetMetadata metadata = SkinImporter.importSkin(filePath);
                if (metadata != null) {
                    QuickSkin.LOGGER.info("Successfully imported skin: {}", (Object)metadata.friendlyName());
                    this.refreshSkinList();
                    if (this.skinListPanel != null) {
                        this.skinListPanel.setSelected(metadata);
                    }
                } else {
                    QuickSkin.LOGGER.error("Failed to import skin: {}", (Object)filePath);
                    this.showError((Component)Component.m_237113_((String)"Failed to import skin"));
                }
            });
        }
    }

    public void refreshSkinList() {
        if (this.skinListPanel != null) {
            this.skinListPanel.refresh();
        }
    }

    public void showError(Component message) {
        this.errorToasts.add(new ErrorToast(message));
    }

    private void renderErrorToasts(GuiGraphics graphics) {
        this.errorToasts.removeIf(toast -> !toast.render(graphics, this.f_96543_));
    }

    public void showDeleteConfirmation(AssetMetadata metadata) {
        if (this.f_96541_ == null) {
            return;
        }
        String displayName = this.truncateFileName(metadata.friendlyName());
        this.f_96541_.m_91152_((Screen)new DeletionConfirmScreen(this, (Component)Component.m_237113_((String)"Delete Skin?"), (Component)Component.m_237113_((String)("Are you sure you want to delete \"" + displayName + "\"?")), confirmed -> {
            if (confirmed.booleanValue()) {
                this.deleteSkin(metadata);
            }
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, true));
    }

    public void showRenameDialog(AssetMetadata metadata) {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new RenameScreen(this, (Component)Component.m_237113_((String)"Rename Skin File"), (Component)Component.m_237119_(), metadata.friendlyName(), newName -> {
            this.renameSkin(metadata, (String)newName);
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)this);
            }
        }));
    }

    private String truncateFileName(String name) {
        if (name.length() <= 35) {
            return name;
        }
        return name.substring(0, 32) + "...";
    }

    private void deleteSkin(AssetMetadata metadata) {
        ClientConfig config = ClientConfig.getInstance();
        if (config.enablePlayerOwnSkinSystem && metadata.hash().equals(config.playerOwnSkinHash)) {
            QuickSkin.LOGGER.warn("Cannot delete player's own skin: {}", (Object)metadata.friendlyName());
            this.showError((Component)Component.m_237113_((String)"Cannot delete your own skin!"));
            return;
        }
        try {
            AssetMetadata playerOwnSkin;
            Files.deleteIfExists(metadata.path());
            if (this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f));
            }
            LocalAssetManager.getInstance().discoverLocalAssets();
            this.refreshSkinList();
            if (!config.playerOwnSkinHash.isEmpty() && this.skinListPanel != null && (playerOwnSkin = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
                this.skinListPanel.setSelected(playerOwnSkin, true);
                QuickSkin.LOGGER.info("Auto-selected player's own skin after deletion");
            }
            QuickSkin.LOGGER.info("Deleted skin: {}", (Object)metadata.friendlyName());
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to delete skin: {}", (Object)metadata.friendlyName(), (Object)e);
            this.showError((Component)Component.m_237113_((String)("Failed to delete skin: " + e.getMessage())));
        }
    }

    private void renameSkin(AssetMetadata metadata, String newName) {
        LocalAssetManager.RenameResult result = LocalAssetManager.getInstance().renameLocalAsset(metadata.hash(), newName);
        switch (result) {
            case SUCCESS: {
                AssetMetadata updatedMetadata;
                QuickSkin.LOGGER.info("Successfully renamed skin to: {}", (Object)newName);
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f));
                }
                this.refreshSkinList();
                if (this.skinListPanel == null || (updatedMetadata = LocalAssetManager.getInstance().getMetadata(metadata.hash())) == null) break;
                this.skinListPanel.setSelected(updatedMetadata);
                break;
            }
            case NAME_TAKEN: {
                QuickSkin.LOGGER.warn("Rename failed: Name already exists");
                this.showError((Component)Component.m_237113_((String)"Error: A skin file with that name already exists."));
                break;
            }
            case INVALID_NAME: {
                QuickSkin.LOGGER.warn("Rename failed: Invalid name");
                this.showError((Component)Component.m_237113_((String)"Error: The name contains invalid characters or is empty."));
                break;
            }
            case IO_ERROR: {
                QuickSkin.LOGGER.error("Rename failed: IO error");
                this.showError((Component)Component.m_237113_((String)"Error: Could not rename the file. See logs."));
                break;
            }
            case NOT_FOUND: {
                QuickSkin.LOGGER.error("Rename failed: File not found");
                this.showError((Component)Component.m_237113_((String)"Error: Could not find the original file."));
            }
        }
    }

    private void onUsernameFieldChanged(String text) {
        if (this.searchButton != null) {
            this.searchButton.f_93623_ = !text.trim().isEmpty() && !this.isSearching;
        }
    }

    private void searchMojangSkin() {
        if (this.usernameSearchField == null || this.isSearching) {
            return;
        }
        String username = this.usernameSearchField.m_94155_().trim();
        if (username.isEmpty()) {
            return;
        }
        this.isSearching = true;
        this.searchButton.f_93623_ = false;
        this.searchButton.m_93666_((Component)Component.m_237113_((String)"Searching..."));
        QuickSkin.LOGGER.info("Searching for Mojang skin: {}", (Object)username);
        ((CompletableFuture)MojangApiService.getInstance().fetchSkinByUsername(username).thenAccept(skinData -> {
            if (this.f_96541_ != null) {
                this.f_96541_.execute(() -> {
                    if (skinData != null) {
                        this.handleMojangSkinFetched((MojangApiService.MojangSkinData)skinData);
                    } else {
                        this.showError((Component)Component.m_237113_((String)("Player not found: " + username)));
                        this.resetSearchButton();
                    }
                });
            }
        })).exceptionally(throwable -> {
            QuickSkin.LOGGER.error("Error fetching Mojang skin", throwable);
            if (this.f_96541_ != null) {
                this.f_96541_.execute(() -> {
                    this.showError((Component)Component.m_237113_((String)("Failed to fetch skin: " + throwable.getMessage())));
                    this.resetSearchButton();
                });
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMojangSkinFetched(MojangApiService.MojangSkinData skinData) {
        try {
            Path skinPath = SkinImporter.saveSkinImage(skinData.image, skinData.username);
            if (skinPath != null) {
                QuickSkin.LOGGER.info("Successfully saved Mojang skin for: {}", (Object)skinData.username);
                LocalAssetManager.getInstance().reload();
                String hash = HashUtil.computeFileHash(skinPath);
                if (hash != null) {
                    AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(hash);
                    if (metadata != null) {
                        this.refreshSkinList();
                        if (this.skinListPanel != null) {
                            this.skinListPanel.setSelected(metadata);
                        }
                        this.usernameSearchField.m_94144_("");
                        if (this.f_96541_ != null) {
                            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f));
                        }
                    } else {
                        this.showError((Component)Component.m_237113_((String)"Failed to load skin metadata"));
                    }
                } else {
                    this.showError((Component)Component.m_237113_((String)"Failed to compute file hash"));
                }
            } else {
                this.showError((Component)Component.m_237113_((String)"Failed to save skin image"));
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error handling Mojang skin", (Throwable)e);
            this.showError((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
        }
        finally {
            this.resetSearchButton();
        }
    }

    private void resetSearchButton() {
        this.isSearching = false;
        if (this.searchButton != null) {
            this.searchButton.m_93666_((Component)Component.m_237113_((String)"Search"));
            this.searchButton.f_93623_ = this.usernameSearchField != null && !this.usernameSearchField.m_94155_().trim().isEmpty();
        }
    }
}

