/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.client.gui.widget.SkinListWidget;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.config.ClientConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinEntry
extends ContainerObjectSelectionList.Entry<SkinEntry> {
    private final Minecraft mc;
    private final AssetMetadata metadata;
    private final ResourceLocation textureLocation;
    private final SkinListWidget parentList;
    private boolean isDeleteHovered;
    private boolean isEditHovered;

    public SkinEntry(SkinListWidget parentList, AssetMetadata metadata) {
        this.parentList = parentList;
        this.metadata = metadata;
        this.mc = Minecraft.m_91087_();
        this.textureLocation = LocalAssetManager.getInstance().getTextureLocation(metadata.hash(), TextureQuality.PREVIEW);
    }

    public AssetMetadata getMetadata() {
        return this.metadata;
    }

    public String getSortName() {
        return this.metadata.friendlyName();
    }

    public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
        Object modelText;
        boolean isPlayerOwnSkin;
        int highlightPaddingH = 4;
        int highlightPaddingV = 2;
        int highlightLeft = left - highlightPaddingH;
        int highlightRight = left + width - 10;
        int highlightTop = top - highlightPaddingV;
        int highlightBottom = top + height + highlightPaddingV;
        ClientConfig config = ClientConfig.getInstance();
        boolean bl = isPlayerOwnSkin = config.enablePlayerOwnSkinSystem && this.metadata.hash().equals(config.playerOwnSkinHash);
        if (this.parentList.m_93511_() == this) {
            if (isPlayerOwnSkin) {
                graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, -2136989456);
                graphics.m_280637_(highlightLeft, highlightTop, highlightRight - highlightLeft, highlightBottom - highlightTop, -6283024);
            } else {
                graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, -2144301888);
                graphics.m_280637_(highlightLeft, highlightTop, highlightRight - highlightLeft, highlightBottom - highlightTop, -12549889);
            }
        } else if (isHovered) {
            graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, 0x30FFFFFF);
        }
        int faceSize = height - 8;
        int faceX = left + 4;
        int faceY = top + 4;
        if (this.textureLocation != null) {
            RenderSystem.enableBlend();
            int textureWidth = this.metadata.resolution().getWidth();
            int textureHeight = this.metadata.resolution().getHeight();
            float scaleX = (float)textureWidth / 64.0f;
            float scaleY = (float)textureHeight / 64.0f;
            graphics.m_280411_(this.textureLocation, faceX, faceY, faceSize, faceSize, 8.0f * scaleX, 8.0f * scaleY, (int)(8.0f * scaleX), (int)(8.0f * scaleY), textureWidth, textureHeight);
            graphics.m_280411_(this.textureLocation, faceX, faceY, faceSize, faceSize, 40.0f * scaleX, 8.0f * scaleY, (int)(8.0f * scaleX), (int)(8.0f * scaleY), textureWidth, textureHeight);
            RenderSystem.disableBlend();
        } else {
            graphics.m_280509_(faceX, faceY, faceX + faceSize, faceY + faceSize, -13421773);
            graphics.m_280137_(this.mc.f_91062_, "?", faceX + faceSize / 2, faceY + faceSize / 2 - 4, 0xFFFFFF);
        }
        int textX = left + faceSize + 12;
        int actionButtonSize = 11;
        int buttonAreaWidth = actionButtonSize + 8;
        int textMaxWidth = highlightRight - buttonAreaWidth - textX;
        Object displayName = this.getSortName();
        if (this.mc.f_91062_.m_92895_((String)displayName) > textMaxWidth) {
            displayName = this.mc.f_91062_.m_92834_((String)displayName, textMaxWidth - this.mc.f_91062_.m_92895_("...")) + "...";
        }
        graphics.m_280488_(this.mc.f_91062_, (String)displayName, textX, top + 6, 0xFFFFFF);
        Object object = modelText = "slim".equalsIgnoreCase(this.metadata.skinModel()) ? "Slim" : "Classic";
        if (this.metadata.resolution().isHD()) {
            modelText = (String)modelText + " \u2022 " + this.metadata.resolution().name();
        }
        Font font = this.mc.f_91062_;
        Objects.requireNonNull(this.mc.f_91062_);
        graphics.m_280488_(font, (String)modelText, textX, top + 6 + 9 + 2, this.metadata.resolution().isHD() ? 0x55FF55 : 0xAAAAAA);
        this.isDeleteHovered = false;
        this.isEditHovered = false;
        if (isHovered && !isPlayerOwnSkin) {
            int margin = 4;
            int deleteButtonX = highlightRight - actionButtonSize - margin;
            int deleteButtonY = highlightTop + margin;
            boolean deleteHovered = mouseX >= deleteButtonX && mouseX < deleteButtonX + actionButtonSize && mouseY >= deleteButtonY && mouseY < deleteButtonY + actionButtonSize;
            graphics.m_280509_(deleteButtonX, deleteButtonY, deleteButtonX + actionButtonSize, deleteButtonY + actionButtonSize, deleteHovered ? -1595916224 : -2134900736);
            graphics.m_280488_(this.mc.f_91062_, "x", deleteButtonX + 3, deleteButtonY + 1, 0xFFFFFF);
            this.isDeleteHovered = deleteHovered;
            int editButtonY = deleteButtonY + actionButtonSize + 2;
            boolean editHovered = mouseX >= deleteButtonX && mouseX < deleteButtonX + actionButtonSize && mouseY >= editButtonY && mouseY < editButtonY + actionButtonSize;
            graphics.m_280509_(deleteButtonX, editButtonY, deleteButtonX + actionButtonSize, editButtonY + actionButtonSize, editHovered ? -1606369088 : -2143256448);
            graphics.m_280488_(this.mc.f_91062_, "\u270e", deleteButtonX + 2, editButtonY + 1, -1);
            this.isEditHovered = editHovered;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isDeleteHovered) {
                this.parentList.requestDeletion(this);
                return true;
            }
            if (this.isEditHovered) {
                this.parentList.requestRename(this);
                return true;
            }
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.25f));
            this.parentList.m_6987_((AbstractSelectionList.Entry)this);
            this.parentList.onSkinSelected(this);
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return List.of();
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return List.of();
    }
}

