/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.widget.SkinEntry;
import com.quickskin.mod.common.data.AssetMetadata;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinListWidget
extends ContainerObjectSelectionList<SkinEntry> {
    private final PlayerSkinMenuScreen parentScreen;
    private final Minecraft mc;

    public SkinListWidget(PlayerSkinMenuScreen parentScreen, Minecraft mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
        this.parentScreen = parentScreen;
        this.mc = mc;
    }

    public void addSkinEntry(AssetMetadata metadata) {
        this.m_7085_((AbstractSelectionList.Entry)new SkinEntry(this, metadata));
    }

    public void clearSkinEntries() {
        this.m_93516_();
    }

    public void makeVisible(SkinEntry entry) {
        this.m_93498_((AbstractSelectionList.Entry)entry);
    }

    public void onSkinSelected(SkinEntry entry) {
        this.parentScreen.onSkinSelected(entry);
    }

    public int m_5759_() {
        return this.f_93388_ - 8;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    protected void m_239227_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int rowTop;
        int areaTop;
        int areaBottom;
        super.m_239227_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_5773_() <= 2 && (areaBottom = this.f_93391_) - (areaTop = Math.max(rowTop = this.m_5773_() > 0 ? this.m_7610_(this.m_5773_()) : this.f_93390_, this.f_93390_)) > 60) {
            int areaLeft = this.m_5747_();
            int areaWidth = this.m_5759_();
            int centerX = areaLeft + areaWidth / 2;
            int centerY = areaTop + (areaBottom - areaTop) / 2;
            int zoneWidth = Math.min(areaWidth - 40, 300);
            int zoneHeight = Math.min(areaBottom - areaTop - 40, 140);
            int zoneX = centerX - zoneWidth / 2;
            int zoneY = centerY - zoneHeight / 2;
            boolean isHovering = mouseX >= zoneX && mouseX <= zoneX + zoneWidth && mouseY >= zoneY && mouseY <= zoneY + zoneHeight;
            int bgColor = isHovering ? 0x1AFFFFFF : 0xFFFFFFF;
            graphics.m_280509_(zoneX, zoneY, zoneX + zoneWidth, zoneY + zoneHeight, bgColor);
            this.drawDashedBorder(graphics, zoneX, zoneY, zoneWidth, zoneHeight, isHovering);
            MutableComponent mainMessage = Component.m_237113_((String)"Drop skin files here");
            MutableComponent subMessage = Component.m_237113_((String)"or click 'Import Skin'");
            int mainColor = isHovering ? 0xFFFFFF : 0xE0E0E0;
            int subColor = isHovering ? 0xB0B0B0 : 0x909090;
            Font font = this.mc.f_91062_;
            Objects.requireNonNull(this.mc.f_91062_);
            graphics.m_280653_(font, (Component)mainMessage, centerX, centerY - 9 - 2, mainColor);
            graphics.m_280653_(this.mc.f_91062_, (Component)subMessage, centerX, centerY + 2, subColor);
        }
    }

    private void drawDashedBorder(GuiGraphics graphics, int x, int y, int width, int height, boolean highlight) {
        int segmentLength;
        int i;
        int color = highlight ? -1 : -2130706433;
        int dashLength = 8;
        int gapLength = 4;
        int totalLength = dashLength + gapLength;
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y, x + i + segmentLength, y + 1, color);
        }
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y + height - 1, x + i + segmentLength, y + height, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x, y + i, x + 1, y + i + segmentLength, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x + width - 1, y + i, x + width, y + i + segmentLength, color);
        }
    }

    public void requestDeletion(SkinEntry entry) {
        this.parentScreen.showDeleteConfirmation(entry.getMetadata());
    }

    public void requestRename(SkinEntry entry) {
        this.parentScreen.showRenameDialog(entry.getMetadata());
    }
}

