/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.rendering.PreviewPlayerData;
import com.quickskin.mod.client.rendering.SkinLayers3DIntegration;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class PlayerModelRenderer {
    private static PlayerModel<?> classicModel;
    private static PlayerModel<?> slimModel;
    private static long lastAnimationUpdate;
    private static final long ANIMATION_UPDATE_INTERVAL_MS = 33L;
    private static ResourceLocation cachedCapeTexture;
    private static long lastCapeTextureUpdate;
    private static final long CAPE_UPDATE_INTERVAL_MS = 100L;
    private static boolean lightingSetup;
    private static boolean grassBlockCacheBuilt;
    private static Player cachedPlayer;
    private static float prevHeadRotZ;
    private static float prevRightArmRotX;
    private static float prevRightArmRotZ;
    private static float prevLeftArmRotX;
    private static float prevLeftArmRotZ;
    private static float prevRightLegRotX;
    private static float prevLeftLegRotX;
    private static float prevBodyRotX;
    public static double debugOffsetX;
    public static double debugOffsetY;
    public static boolean debugPositioningMode;
    private static boolean isDraggingModel;
    private static int dragStartX;
    private static int dragStartY;
    private static double dragStartOffsetX;
    private static double dragStartOffsetY;

    private static void ensureModelsLoaded() {
        if (classicModel == null) {
            QuickSkin.LOGGER.info("[PlayerModelRenderer] Initializing player models...");
            Minecraft mc = Minecraft.m_91087_();
            ModelPart classicRoot = mc.m_167973_().m_171103_(ModelLayers.f_171162_);
            classicModel = new PlayerModel(classicRoot, false);
            ModelPart slimRoot = mc.m_167973_().m_171103_(ModelLayers.f_171166_);
            slimModel = new PlayerModel(slimRoot, true);
            QuickSkin.LOGGER.info("[PlayerModelRenderer] Models initialized successfully");
        }
    }

    public static void renderPlayerModel(GuiGraphics graphics, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        Player playerToRender;
        if (playerData.getSkinLocation() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            cachedPlayer = mc.f_91074_;
        }
        if ((playerToRender = cachedPlayer) == null) {
            PlayerModelRenderer.renderPlayerModelManual(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
            return;
        }
        float originalYRot = playerToRender.m_146908_();
        float originalXRot = playerToRender.m_146909_();
        float originalYHeadRot = playerToRender.f_20885_;
        float originalYBodyRot = playerToRender.f_20883_;
        float targetRotation = 180.0f + yRotation;
        playerToRender.m_146922_(targetRotation);
        playerToRender.m_146926_(0.0f);
        playerToRender.f_20885_ = targetRotation + playerData.getHeadYaw();
        playerToRender.f_20883_ = targetRotation;
        if (mc.f_91073_ == null) {
            playerToRender.f_19797_ = mc.f_91065_.m_93079_();
        }
        Quaternionf quaternionXZ = new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI);
        Quaternionf quaternionY = new Quaternionf();
        try {
            if ("sit".equalsIgnoreCase(playerData.getCurrentAnimation()) && mc.f_91073_ == null) {
                PoseStack poseStack = graphics.m_280168_();
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, 50.0);
                float scaleCasted = (int)scale;
                Matrix4f scaleMatrix = new Matrix4f().scaling(scaleCasted, scaleCasted, -scaleCasted);
                poseStack.m_252931_(scaleMatrix);
                poseStack.m_252781_(quaternionXZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-targetRotation));
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                poseStack.m_252880_(0.0f, -1.501f, 0.0f);
                PlayerModelRenderer.renderGrassBlock(poseStack, bufferSource);
                bufferSource.m_109911_();
                poseStack.m_85849_();
            }
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)x, (int)y, (int)((int)scale), (Quaternionf)quaternionXZ, (Quaternionf)quaternionY, (LivingEntity)playerToRender);
        }
        catch (Exception e) {
            PlayerModelRenderer.renderPlayerModelManual(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
        }
        playerToRender.m_146922_(originalYRot);
        playerToRender.m_146926_(originalXRot);
        playerToRender.f_20885_ = originalYHeadRot;
        playerToRender.f_20883_ = originalYBodyRot;
    }

    private static void renderPlayerModelManual(GuiGraphics graphics, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        PlayerModelRenderer.ensureModelsLoaded();
        PlayerModel<?> model = playerData.getModelType().equalsIgnoreCase("slim") ? slimModel : classicModel;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        float scaleCasted = (int)scale;
        Matrix4f scaleMatrix = new Matrix4f().scaling(scaleCasted, scaleCasted, -scaleCasted);
        poseStack.m_252931_(scaleMatrix);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        poseStack.m_252781_(quaternionf);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRotation));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        if (!lightingSetup) {
            Lighting.m_166384_();
            lightingSetup = true;
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        if ("sit".equalsIgnoreCase(playerData.getCurrentAnimation()) && mc.f_91073_ == null) {
            PlayerModelRenderer.renderGrassBlock(poseStack, bufferSource);
        }
        PlayerModelRenderer.setupModelPoseWithAnimation(model, playerData, mouseX, mouseY, followMouse, x, y, mc);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)playerData.getSkinLocation());
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        boolean isSlimModel = playerData.getModelType().equalsIgnoreCase("slim");
        model.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        SkinLayers3DIntegration.render3DLayers(poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, model, playerData.getSkinLocation(), isSlimModel);
        if (playerData.getCapeLocation() != null) {
            ResourceLocation capeAtlasLocation = playerData.getCapeLocation();
            String capeId = playerData.getCapeId();
            ResourceLocation finalCapeTexture = capeAtlasLocation;
            String animationId = null;
            if (capeId != null) {
                if (capeId.startsWith("local_cape:")) {
                    animationId = "cape_" + capeId.substring("local_cape:".length());
                } else if (capeId.startsWith("known:")) {
                    animationId = "cape_known_" + capeId.substring("known:".length());
                }
            }
            if (animationId != null) {
                long now = System.currentTimeMillis();
                if (now - lastCapeTextureUpdate >= 100L) {
                    ResourceLocation currentFrame = AnimatedTextureManager.getInstance().getCurrentFrameTexture(animationId);
                    if (currentFrame != null) {
                        cachedCapeTexture = currentFrame;
                    }
                    lastCapeTextureUpdate = now;
                }
                if (cachedCapeTexture != null) {
                    finalCapeTexture = cachedCapeTexture;
                }
            }
            RenderType capeRenderType = RenderType.m_110473_((ResourceLocation)finalCapeTexture);
            VertexConsumer capeVertexConsumer = bufferSource.m_6299_(capeRenderType);
            poseStack.m_85836_();
            model.f_102810_.m_104299_(poseStack);
            poseStack.m_85837_(0.0, 0.0, 0.125);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(6.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            model.m_103411_(poseStack, capeVertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    @Deprecated
    public static void renderPlayerModel(PoseStack poseStack, MultiBufferSource buffer, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics graphics = new GuiGraphics(mc, buffer instanceof MultiBufferSource.BufferSource ? (MultiBufferSource.BufferSource)buffer : mc.m_91269_().m_110104_());
        PlayerModelRenderer.renderPlayerModel(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
    }

    private static float smoothLerp(float current, float target, float factor) {
        return current + (target - current) * factor;
    }

    private static void renderCapeLayer(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, ResourceLocation capeTexture, PlayerModel<?> model) {
        poseStack.m_85836_();
        model.f_102810_.m_104299_(poseStack);
        poseStack.m_85837_(0.0, 0.0, 0.125);
        float capeWidth = 0.625f;
        float capeHeight = 1.0f;
        float xOffset = -capeWidth / 2.0f;
        RenderType capeRenderType = RenderType.m_110446_((ResourceLocation)capeTexture);
        VertexConsumer capeConsumer = bufferSource.m_6299_(capeRenderType);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 0.15625f;
        float v1 = 0.5f;
        capeConsumer.m_252986_(matrix, xOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        capeConsumer.m_252986_(matrix, xOffset, capeHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        capeConsumer.m_252986_(matrix, xOffset + capeWidth, capeHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        capeConsumer.m_252986_(matrix, xOffset + capeWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderCapeManualOLD(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, ResourceLocation capeLocation, float yRotation) {
        poseStack.m_85836_();
        RenderType debugRenderType = RenderType.m_285907_();
        VertexConsumer debugConsumer = bufferSource.m_6299_(debugRenderType);
        PoseStack.Pose debugPose = poseStack.m_85850_();
        Matrix4f debugMatrix = debugPose.m_252922_();
        float debugSize = 2.5f;
        debugConsumer.m_252986_(debugMatrix, -debugSize, -debugSize, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(0.0f, 0.0f).m_5752_();
        debugConsumer.m_252986_(debugMatrix, -debugSize, debugSize, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(0.0f, 1.0f).m_5752_();
        debugConsumer.m_252986_(debugMatrix, debugSize, debugSize, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(1.0f, 1.0f).m_5752_();
        debugConsumer.m_252986_(debugMatrix, debugSize, -debugSize, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(1.0f, 0.0f).m_5752_();
        poseStack.m_85837_(0.0, 0.0, -0.125);
        float capeWidth = 0.625f;
        float capeHeight = 1.0f;
        float xOffset = -capeWidth / 2.0f;
        float capeSwing = (float)Math.sin((double)System.currentTimeMillis() / 1000.0) * 0.1f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(capeSwing * 10.0f));
        RenderType renderType = RenderType.m_110470_((ResourceLocation)capeLocation);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f positionMatrix = pose.m_252922_();
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 0.15625f;
        float v1 = 0.5f;
        vertexConsumer.m_252986_(positionMatrix, xOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(positionMatrix, xOffset, capeHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(positionMatrix, xOffset + capeWidth, capeHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(positionMatrix, xOffset + capeWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void setupModelPoseWithAnimation(PlayerModel<?> model, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse, int modelCenterX, int modelCenterY, Minecraft mc) {
        long now;
        boolean shouldUpdate;
        String animation = playerData.getCurrentAnimation();
        if (animation == null || animation.isEmpty()) {
            animation = "idle";
        }
        boolean bl = shouldUpdate = (now = System.currentTimeMillis()) - lastAnimationUpdate >= 33L;
        if (!shouldUpdate) {
            model.f_102809_.m_104315_(model.f_102808_);
            model.f_103374_.m_104315_(model.f_102812_);
            model.f_103375_.m_104315_(model.f_102811_);
            model.f_103376_.m_104315_(model.f_102814_);
            model.f_103377_.m_104315_(model.f_102813_);
            model.f_103378_.m_104315_(model.f_102810_);
            return;
        }
        lastAnimationUpdate = now;
        int tickCount = mc != null ? mc.f_91065_.m_93079_() : 0;
        float elapsedTime = (float)tickCount / 20.0f;
        float t = elapsedTime * 0.8f;
        float lerpFactor = 0.15f;
        switch (animation.toLowerCase()) {
            case "walk": {
                PlayerModelRenderer.setupWalkingPose(model, t, lerpFactor);
                break;
            }
            case "sit": {
                PlayerModelRenderer.setupSittingPose(model, t, lerpFactor);
                break;
            }
            default: {
                PlayerModelRenderer.setupIdlePose(model, t, lerpFactor);
            }
        }
        model.f_102809_.m_104315_(model.f_102808_);
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103376_.m_104315_(model.f_102814_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_103378_.m_104315_(model.f_102810_);
    }

    private static void setupIdlePose(PlayerModel<?> model, float t, float lerpFactor) {
        model.f_102610_ = false;
        model.f_102817_ = false;
        model.f_102609_ = false;
        model.f_102608_ = 0.0f;
        float targetHeadRotZ = (float)Math.sin((double)t * 1.2) * 0.04f;
        prevHeadRotZ = PlayerModelRenderer.smoothLerp(prevHeadRotZ, targetHeadRotZ, lerpFactor);
        model.f_102808_.f_104203_ = 0.0f;
        model.f_102808_.f_104204_ = 0.0f;
        model.f_102808_.f_104205_ = prevHeadRotZ;
        float targetBodyBounce = (float)Math.abs(Math.sin((double)t * 0.8)) * 0.12f;
        prevBodyRotX = PlayerModelRenderer.smoothLerp(prevBodyRotX, targetBodyBounce * 0.2f, lerpFactor);
        model.f_102810_.f_104203_ = -prevBodyRotX;
        model.f_102810_.f_104204_ = 0.0f;
        model.f_102810_.f_104205_ = 0.0f;
        float targetRightArmRotX = (float)Math.sin((double)t * 0.8) * 0.12f;
        float targetRightArmRotZ = (float)Math.sin(t) * 0.04f;
        prevRightArmRotX = PlayerModelRenderer.smoothLerp(prevRightArmRotX, targetRightArmRotX, lerpFactor);
        prevRightArmRotZ = PlayerModelRenderer.smoothLerp(prevRightArmRotZ, targetRightArmRotZ, lerpFactor);
        model.f_102811_.f_104203_ = prevRightArmRotX;
        model.f_102811_.f_104204_ = 0.0f;
        model.f_102811_.f_104205_ = prevRightArmRotZ;
        float targetLeftArmRotX = (float)Math.sin((double)t * 0.8 + Math.PI) * 0.12f;
        float targetLeftArmRotZ = (float)Math.sin((double)t + Math.PI) * -0.04f;
        prevLeftArmRotX = PlayerModelRenderer.smoothLerp(prevLeftArmRotX, targetLeftArmRotX, lerpFactor);
        prevLeftArmRotZ = PlayerModelRenderer.smoothLerp(prevLeftArmRotZ, targetLeftArmRotZ, lerpFactor);
        model.f_102812_.f_104203_ = prevLeftArmRotX;
        model.f_102812_.f_104204_ = 0.0f;
        model.f_102812_.f_104205_ = prevLeftArmRotZ;
        float targetRightLegRotX = (float)Math.sin((double)t * 0.5) * 0.05f;
        model.f_102813_.f_104203_ = prevRightLegRotX = PlayerModelRenderer.smoothLerp(prevRightLegRotX, targetRightLegRotX, lerpFactor);
        model.f_102813_.f_104204_ = 0.0f;
        model.f_102813_.f_104205_ = 0.0f;
        float targetLeftLegRotX = (float)Math.sin((double)t * 0.5 + Math.PI) * 0.05f;
        model.f_102814_.f_104203_ = prevLeftLegRotX = PlayerModelRenderer.smoothLerp(prevLeftLegRotX, targetLeftLegRotX, lerpFactor);
        model.f_102814_.f_104204_ = 0.0f;
        model.f_102814_.f_104205_ = 0.0f;
    }

    private static void setupWalkingPose(PlayerModel<?> model, float t, float lerpFactor) {
        model.f_102610_ = false;
        model.f_102817_ = false;
        model.f_102609_ = false;
        model.f_102608_ = 0.0f;
        float limbSwing = (float)Math.sin((double)t * 8.0) * 0.6f;
        float headBobY = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.05f;
        float headTiltZ = (float)Math.sin((double)t * 8.0) * 0.03f;
        model.f_102808_.f_104203_ = -headBobY;
        model.f_102808_.f_104204_ = 0.0f;
        model.f_102808_.f_104205_ = headTiltZ;
        float bodySway = (float)Math.sin((double)t * 8.0) * 0.04f;
        float bodyBob = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.02f;
        model.f_102810_.f_104203_ = 0.05f + bodyBob;
        model.f_102810_.f_104204_ = bodySway;
        model.f_102810_.f_104205_ = bodySway * 0.5f;
        float armSwingOut = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.05f;
        model.f_102811_.f_104203_ = -limbSwing;
        model.f_102811_.f_104204_ = 0.0f;
        model.f_102811_.f_104205_ = armSwingOut;
        model.f_102812_.f_104203_ = limbSwing;
        model.f_102812_.f_104204_ = 0.0f;
        model.f_102812_.f_104205_ = -armSwingOut;
        model.f_102813_.f_104203_ = limbSwing;
        model.f_102813_.f_104204_ = 0.0f;
        model.f_102813_.f_104205_ = 0.0f;
        model.f_102814_.f_104203_ = -limbSwing;
        model.f_102814_.f_104204_ = 0.0f;
        model.f_102814_.f_104205_ = 0.0f;
    }

    private static void setupSittingPose(PlayerModel<?> model, float t, float lerpFactor) {
        float breathe;
        model.f_102610_ = false;
        model.f_102817_ = false;
        model.f_102609_ = true;
        model.f_102608_ = 0.0f;
        float headBob = (float)Math.sin((double)t * 0.6) * 0.02f;
        float headTilt = (float)Math.sin((double)t * 0.4) * 0.03f;
        model.f_102808_.f_104203_ = headBob;
        model.f_102808_.f_104204_ = 0.0f;
        model.f_102808_.f_104205_ = headTilt;
        model.f_102810_.f_104203_ = breathe = (float)Math.sin((double)t * 0.5) * 0.01f;
        model.f_102810_.f_104204_ = 0.0f;
        model.f_102810_.f_104205_ = 0.0f;
        float armSway = (float)Math.sin((double)t * 0.7) * 0.02f;
        model.f_102811_.f_104203_ = -0.62f + armSway;
        model.f_102811_.f_104204_ = 0.0f;
        model.f_102811_.f_104205_ = 0.0f;
        model.f_102812_.f_104203_ = -0.62f - armSway;
        model.f_102812_.f_104204_ = 0.0f;
        model.f_102812_.f_104205_ = 0.0f;
        float legFidget = (float)Math.sin((double)t * 0.3) * 0.01f;
        model.f_102813_.f_104203_ = -1.4f + legFidget;
        model.f_102813_.f_104204_ = 0.31f;
        model.f_102813_.f_104205_ = 0.05f;
        model.f_102814_.f_104203_ = -1.4f - legFidget;
        model.f_102814_.f_104204_ = -0.31f;
        model.f_102814_.f_104205_ = -0.05f;
    }

    private static void renderGrassBlock(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        poseStack.m_85836_();
        double offsetX = -0.333;
        double offsetY = 1.4;
        double offsetZ = 0.222;
        double scale = 0.575;
        poseStack.m_85837_(offsetX, offsetY, offsetZ);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        if (!grassBlockCacheBuilt) {
            QuickSkin.LOGGER.info("[PlayerModelRenderer] Grass block cache initialized");
            grassBlockCacheBuilt = true;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        blockRenderer.m_110912_(Blocks.f_50440_.m_49966_(), poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    private static void renderCubeFace(Matrix4f matrix, PoseStack.Pose pose, MultiBufferSource.BufferSource bufferSource, ResourceLocation texture, float x1, float y1, float z1, float x2, float y2, float z2, float nx, float ny, float nz) {
        RenderType renderType = RenderType.m_110452_((ResourceLocation)texture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float minZ = Math.min(z1, z2);
        float maxZ = Math.max(z1, z2);
        if (ny != 0.0f) {
            float y = y1;
            vertexConsumer.m_252986_(matrix, minX, y, minZ).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, minX, y, maxZ).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, maxX, y, maxZ).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, maxX, y, minZ).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
        } else if (nx != 0.0f) {
            float x = x1;
            vertexConsumer.m_252986_(matrix, x, minY, minZ).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, x, maxY, minZ).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, x, maxY, maxZ).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, x, minY, maxZ).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
        } else {
            float z = z1;
            vertexConsumer.m_252986_(matrix, minX, minY, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, minX, maxY, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, maxX, maxY, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
            vertexConsumer.m_252986_(matrix, maxX, minY, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
        }
    }

    private static void renderDebugCube(PoseStack poseStack, MultiBufferSource buffer, PlayerModel<?> model) {
        poseStack.m_85836_();
        ModelPart body = model.f_102810_;
        poseStack.m_85837_(0.0, -0.7, 0.0);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        RenderType renderType = RenderType.m_110504_();
        VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
        float size = 1.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, -size, size, -size, -size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, -size, size, -size, size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, size, -size, -size, size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, size, -size, -size, -size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, size, -size, size, size, -size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, size, -size, size, size, size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, size, size, -size, size, size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, size, size, -size, size, -size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, -size, -size, size, -size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, -size, size, size, -size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, size, size, size, size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, size, -size, size, size, 255, 255, 0);
        poseStack.m_85849_();
    }

    private static void addLine(VertexConsumer consumer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b) {
        consumer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void setupLighting(float yRotation) {
        float normalizedRotation = yRotation % 360.0f;
        if (normalizedRotation < 0.0f) {
            normalizedRotation += 360.0f;
        }
        float brightness = normalizedRotation < 90.0f ? 1.425f - normalizedRotation / 90.0f * 0.225f : (normalizedRotation < 180.0f ? 1.2f + (normalizedRotation - 90.0f) / 90.0f * 0.1f : (normalizedRotation < 270.0f ? 1.3f - (normalizedRotation - 180.0f) / 90.0f * 0.1f : 1.2f + (normalizedRotation - 270.0f) / 90.0f * 0.225f));
        Vector3f lightDirection = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
        RenderSystem.setShaderLights((Vector3f)new Vector3f((Vector3fc)lightDirection).mul(brightness), (Vector3f)new Vector3f((Vector3fc)lightDirection).mul(brightness * 0.5f));
    }

    public static void renderDefaultPlayer(PoseStack poseStack, MultiBufferSource buffer, int x, int y, float scale, float yRotation) {
        PreviewPlayerData defaultData = new PreviewPlayerData();
        defaultData.setSkinLocation(new ResourceLocation("textures/entity/steve.png"));
        defaultData.setModelType("classic");
        PlayerModelRenderer.renderPlayerModel(poseStack, buffer, x, y, scale, yRotation, defaultData, 0, 0, false);
    }

    public static void clearCachedPlayer() {
        cachedPlayer = null;
        QuickSkin.LOGGER.info("[PlayerModelRenderer] Cached player cleared");
    }

    public static void resetLightingState() {
        lightingSetup = false;
    }

    public static void clearGrassBlockCache() {
        grassBlockCacheBuilt = false;
    }

    public static boolean handleDebugMousePressed(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || button != 0) {
            return false;
        }
        isDraggingModel = true;
        dragStartX = mouseX;
        dragStartY = mouseY;
        dragStartOffsetX = debugOffsetX;
        dragStartOffsetY = debugOffsetY;
        return true;
    }

    public static boolean handleDebugMouseDragged(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || !isDraggingModel || button != 0) {
            return false;
        }
        int deltaX = mouseX - dragStartX;
        int deltaY = mouseY - dragStartY;
        debugOffsetX = dragStartOffsetX + (double)deltaX;
        debugOffsetY = dragStartOffsetY + (double)deltaY;
        return true;
    }

    public static boolean handleDebugMouseReleased(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || !isDraggingModel || button != 0) {
            return false;
        }
        isDraggingModel = false;
        QuickSkin.LOGGER.info("========================================");
        QuickSkin.LOGGER.info("[Debug Positioning] Model positioned!");
        QuickSkin.LOGGER.info("[Debug Positioning] Set these values in PlayerModelRenderer:");
        QuickSkin.LOGGER.info("[Debug Positioning]   debugOffsetX = {};", (Object)debugOffsetX);
        QuickSkin.LOGGER.info("[Debug Positioning]   debugOffsetY = {};", (Object)debugOffsetY);
        QuickSkin.LOGGER.info("========================================");
        return true;
    }

    static {
        lastAnimationUpdate = 0L;
        cachedCapeTexture = null;
        lastCapeTextureUpdate = 0L;
        lightingSetup = false;
        grassBlockCacheBuilt = false;
        prevHeadRotZ = 0.0f;
        prevRightArmRotX = 0.0f;
        prevRightArmRotZ = 0.0f;
        prevLeftArmRotX = 0.0f;
        prevLeftArmRotZ = 0.0f;
        prevRightLegRotX = 0.0f;
        prevLeftLegRotX = 0.0f;
        prevBodyRotX = 0.0f;
        debugOffsetX = 2.0;
        debugOffsetY = -129.0;
        debugPositioningMode = false;
        isDraggingModel = false;
        dragStartX = 0;
        dragStartY = 0;
        dragStartOffsetX = 0.0;
        dragStartOffsetY = 0.0;
    }
}

