/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.config.ClientConfig;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedTextureManager {
    private static AnimatedTextureManager instance;
    private final Map<String, AnimationState> animations = new ConcurrentHashMap<String, AnimationState>();

    private AnimatedTextureManager() {
    }

    public static AnimatedTextureManager getInstance() {
        if (instance == null) {
            instance = new AnimatedTextureManager();
        }
        return instance;
    }

    public void registerAnimation(String animationId, String capeId, ResourceLocation textureLocation, BufferedImage atlasImage, AnimationMetadata metadata) {
        if (metadata == null || metadata.frameCount() <= 1) {
            QuickSkin.LOGGER.warn("Cannot register animation with invalid metadata (frameCount <= 1): {}", (Object)animationId);
            return;
        }
        this.unregisterAnimation(animationId);
        float speedMultiplier = ClientConfig.getInstance().getCapeAnimationSpeed(capeId);
        AnimationState state = new AnimationState(animationId, textureLocation, atlasImage, metadata, speedMultiplier);
        this.animations.put(animationId, state);
        QuickSkin.LOGGER.debug("Registered animation: {} with {} frames at speed {}x", new Object[]{animationId, metadata.frameCount(), Float.valueOf(speedMultiplier)});
    }

    public void clearAnimations() {
        QuickSkin.LOGGER.info("Clearing all animated texture registrations");
        for (AnimationState state : this.animations.values()) {
            state.cleanup();
        }
        this.animations.clear();
    }

    public void unregisterAnimation(String animationId) {
        AnimationState removed = this.animations.remove(animationId);
        if (removed != null) {
            removed.cleanup();
            QuickSkin.LOGGER.debug("Unregistered and cleaned up animation: {}", (Object)animationId);
        }
    }

    public void setAnimationSpeed(String animationId, float speed) {
        AnimationState state = this.animations.get(animationId);
        if (state != null) {
            state.setSpeedMultiplier(speed);
            QuickSkin.LOGGER.debug("Updated animation speed for {}: {}x", (Object)animationId, (Object)Float.valueOf(speed));
        }
    }

    public boolean isAnimated(String animationId) {
        return this.animations.containsKey(animationId);
    }

    @Nullable
    public ResourceLocation getCurrentFrameTexture(String animationId) {
        AnimationState state = this.animations.get(animationId);
        if (state != null) {
            return state.getCurrentFrameTexture();
        }
        return null;
    }

    public ResourceLocation getTextureLocation(String animationId) {
        AnimationState state = this.animations.get(animationId);
        if (state == null) {
            return null;
        }
        return state.atlasTextureLocation;
    }

    public AnimationMetadata getMetadata(String animationId) {
        AnimationState state = this.animations.get(animationId);
        if (state == null) {
            return null;
        }
        return state.metadata;
    }

    public Optional<ResourceLocation> getAnimationFrame(ResourceLocation atlasLocation) {
        if (atlasLocation == null) {
            return Optional.empty();
        }
        for (AnimationState state : this.animations.values()) {
            if (!atlasLocation.equals((Object)state.atlasTextureLocation)) continue;
            return Optional.ofNullable(state.getCurrentFrameTexture());
        }
        return Optional.empty();
    }

    public void tick() {
        for (AnimationState state : this.animations.values()) {
            state.tick();
        }
    }

    private static class AnimationState {
        final ResourceLocation atlasTextureLocation;
        final AnimationMetadata metadata;
        final long startTime;
        private final DynamicTexture[] frameTextures;
        private final ResourceLocation[] frameResourceLocations;
        private int currentFrame = 0;
        private float speedMultiplier;

        AnimationState(String animationId, ResourceLocation textureLocation, BufferedImage atlasImage, AnimationMetadata metadata, float speedMultiplier) {
            this.atlasTextureLocation = textureLocation;
            this.metadata = metadata;
            this.startTime = System.currentTimeMillis();
            this.speedMultiplier = speedMultiplier;
            this.frameTextures = new DynamicTexture[metadata.frameCount()];
            this.frameResourceLocations = new ResourceLocation[metadata.frameCount()];
            this.loadFrames(animationId, atlasImage);
        }

        private void loadFrames(String animationId, BufferedImage atlasImage) {
            try {
                if (atlasImage == null) {
                    QuickSkin.LOGGER.error("Could not read atlas image for animation: {}", (Object)this.atlasTextureLocation);
                    return;
                }
                int frameWidth = atlasImage.getWidth();
                int frameHeight = this.metadata.frameCount() > 0 ? atlasImage.getHeight() / this.metadata.frameCount() : atlasImage.getHeight();
                for (int i = 0; i < this.metadata.frameCount(); ++i) {
                    BufferedImage frameImage = atlasImage.getSubimage(0, i * frameHeight, frameWidth, frameHeight);
                    NativeImage nativeImage = this.convertToNativeImage(frameImage);
                    this.frameTextures[i] = new DynamicTexture(nativeImage);
                    String frameId = "quickskin/animated/" + animationId.replaceAll("[^a-zA-Z0-9/._-]", "_") + "_frame_" + i;
                    this.frameResourceLocations[i] = Minecraft.m_91087_().m_91097_().m_118490_(frameId, this.frameTextures[i]);
                }
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load and slice animation frames for {}", (Object)this.atlasTextureLocation, (Object)e);
            }
        }

        private NativeImage convertToNativeImage(BufferedImage bufferedImage) {
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            NativeImage nativeImage = new NativeImage(width, height, true);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = bufferedImage.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int abgr = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.m_84988_(x, y, abgr);
                }
            }
            return nativeImage;
        }

        void tick() {
            if (this.metadata.frameCount() <= 1) {
                this.currentFrame = 0;
                return;
            }
            long elapsed = System.currentTimeMillis() - this.startTime;
            long adjustedElapsed = (long)((float)elapsed * this.speedMultiplier);
            this.currentFrame = this.metadata.getFrameAtTime(adjustedElapsed);
        }

        void setSpeedMultiplier(float speed) {
            this.speedMultiplier = speed;
        }

        ResourceLocation getCurrentFrameTexture() {
            if (this.frameResourceLocations == null || this.currentFrame < 0 || this.currentFrame >= this.frameResourceLocations.length || this.frameResourceLocations[this.currentFrame] == null) {
                return this.atlasTextureLocation;
            }
            return this.frameResourceLocations[this.currentFrame];
        }

        void cleanup() {
            for (ResourceLocation resourceLocation : this.frameResourceLocations) {
                if (resourceLocation == null) continue;
                Minecraft.m_91087_().m_91097_().m_118513_(resourceLocation);
            }
            for (ResourceLocation resourceLocation : this.frameTextures) {
                if (resourceLocation == null) continue;
                resourceLocation.close();
            }
        }
    }
}

