/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CapeService;
import com.quickskin.mod.client.services.ICapeService;
import com.quickskin.mod.client.services.IModelService;
import com.quickskin.mod.client.services.IPlayerAppearanceService;
import com.quickskin.mod.client.services.ISkinService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.ModelService;
import com.quickskin.mod.client.services.SkinService;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.common.data.PlayerAppearanceRepository;
import com.quickskin.mod.common.event.InternalEventBus;
import com.quickskin.mod.common.event.PlayerAppearanceUpdateEvent;
import com.quickskin.mod.common.util.TextureAlphaDetector;
import com.quickskin.mod.networking.NetworkSyncService;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAppearanceService
implements IPlayerAppearanceService {
    private static PlayerAppearanceService instance;
    private final PlayerAppearanceRepository repository = PlayerAppearanceRepository.getInstance();
    private final ISkinService skinService = SkinService.getInstance();
    private final ICapeService capeService = CapeService.getInstance();
    private final IModelService modelService = ModelService.getInstance();

    private PlayerAppearanceService() {
    }

    public static PlayerAppearanceService getInstance() {
        if (instance == null) {
            instance = new PlayerAppearanceService();
        }
        return instance;
    }

    public static void init() {
        PlayerAppearanceService.getInstance();
        QuickSkin.LOGGER.info("PlayerAppearanceService initialized");
    }

    @Override
    public void applyLook(UUID playerId, @Nullable String skinId, @Nullable String capeId, @Nullable String model) {
        if (playerId == null) {
            QuickSkin.LOGGER.error("Cannot apply look: playerId is null");
            return;
        }
        QuickSkin.LOGGER.info("Applying look to player {}: skin={}, cape={}, model={}", new Object[]{playerId, skinId, capeId, model});
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        if (appearance == null) {
            appearance = new PlayerAppearance(playerId, "", "", "classic");
            this.repository.setAppearance(appearance);
        }
        if (skinId != null) {
            appearance.setSkinId(skinId);
            String requestedModel = model != null ? model : "auto";
            String resolvedModel = this.modelService.getModelType(playerId, skinId, requestedModel);
            appearance.setModel(resolvedModel);
            this.modelService.setModelOverride(playerId, requestedModel);
            ResourceLocation skinLocation = this.skinService.getSkinLocation(playerId, skinId);
            if (skinLocation != null) {
                appearance.setSkinLocation(skinLocation);
                TextureAlphaDetector.analyzeTextureAsync(skinLocation);
            }
        }
        if (capeId != null) {
            appearance.setCapeId(capeId);
            appearance.setCapeLocation(null);
            ResourceLocation capeLocation = this.capeService.getCapeLocation(playerId, capeId);
            if (capeLocation != null) {
                appearance.setCapeLocation(capeLocation);
                TextureAlphaDetector.analyzeTextureAsync(capeLocation);
                if (this.capeService.isAnimated(capeId)) {
                    String hash = null;
                    String animationId = null;
                    if (capeId.startsWith("local_cape:")) {
                        hash = capeId.substring("local_cape:".length());
                        animationId = "cape_" + hash;
                        AnimationMetadata metadata = LocalAssetManager.getInstance().getAnimationMetadata(hash);
                        BufferedImage atlasImage = LocalAssetManager.getInstance().getSourceImage(hash);
                        if (metadata != null && atlasImage != null) {
                            QuickSkin.LOGGER.info("[PlayerAppearanceService] Registering local cape animation {} for player {}", (Object)animationId, (Object)playerId);
                            AnimatedTextureManager.getInstance().registerAnimation(animationId, capeId, capeLocation, atlasImage, metadata);
                        } else {
                            QuickSkin.LOGGER.warn("[PlayerAppearanceService] Failed to register local cape animation {} - metadata={}, atlasImage={}", new Object[]{animationId, metadata != null, atlasImage != null});
                        }
                    } else if (capeId.startsWith("known:")) {
                        String knownId = capeId.substring("known:".length());
                        this.capeService.loadKnownCape(knownId);
                        QuickSkin.LOGGER.info("[PlayerAppearanceService] Registered known cape animation for player {}: {}", (Object)playerId, (Object)knownId);
                    }
                }
            }
        }
        this.refreshPlayerRenderer(playerId);
        PlayerAppearanceUpdateEvent.UpdateType updateType = skinId != null && capeId != null ? PlayerAppearanceUpdateEvent.UpdateType.FULL : (skinId != null ? PlayerAppearanceUpdateEvent.UpdateType.SKIN : (capeId != null ? PlayerAppearanceUpdateEvent.UpdateType.CAPE : (model != null ? PlayerAppearanceUpdateEvent.UpdateType.MODEL : PlayerAppearanceUpdateEvent.UpdateType.FULL)));
        InternalEventBus.getInstance().post(new PlayerAppearanceUpdateEvent(playerId, appearance));
        QuickSkin.LOGGER.debug("Fired PlayerAppearanceUpdateEvent for {} (type: {})", (Object)playerId, (Object)updateType);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && playerId.equals(mc.f_91074_.m_20148_())) {
            NetworkSyncService.getInstance().syncAppearance(playerId, appearance.getSkinId(), appearance.getCapeId(), appearance.getModel());
        }
    }

    @Override
    public void applySkin(UUID playerId, String skinId, @Nullable String model) {
        this.applyLook(playerId, skinId, null, model);
    }

    @Override
    public void applyCape(UUID playerId, String capeId) {
        this.applyLook(playerId, null, capeId, null);
    }

    @Override
    @Nullable
    public PlayerAppearance getAppearance(UUID playerId) {
        return this.repository.getAppearance(playerId);
    }

    @Override
    public void refreshPlayerRenderer(UUID playerId) {
        AbstractClientPlayer player;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91060_ != null && (player = (AbstractClientPlayer)mc.f_91073_.m_46003_(playerId)) != null) {
            BlockPos pos = player.m_20183_();
            BlockState state = mc.f_91073_.m_8055_(pos);
            mc.f_91060_.m_109721_(pos, state, state);
            this.refreshSkinLayers3D(player);
            QuickSkin.LOGGER.debug("Refreshed renderer for player: {}", (Object)playerId);
        }
    }

    private void refreshSkinLayers3D(AbstractClientPlayer player) {
        try {
            Class<?> skinLayersClass = Class.forName("dev.tr7zw.skinlayers.SkinLayersModBase");
            Method refreshMethod = skinLayersClass.getDeclaredMethod("refreshPlayer", Player.class);
            refreshMethod.setAccessible(true);
            refreshMethod.invoke(null, player);
            QuickSkin.LOGGER.debug("Refreshed SkinLayers3D for player: {}", (Object)player.m_20148_());
        }
        catch (ClassNotFoundException skinLayersClass) {
        }
        catch (Exception e) {
            QuickSkin.LOGGER.debug("Could not refresh SkinLayers3D (mod may have updated): {}", (Object)e.getMessage());
        }
    }

    public boolean hasActiveSkin(UUID playerId) {
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        return appearance != null && appearance.getSkinId() != null && !appearance.getSkinId().isEmpty();
    }

    public boolean hasActiveCape(UUID playerId) {
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        return appearance != null && appearance.getCapeId() != null && !appearance.getCapeId().isEmpty();
    }

    public boolean hasModelOverride(UUID playerId) {
        return this.modelService.hasModelOverride(playerId);
    }

    @Nullable
    public ResourceLocation getSkinLocation(UUID playerId) {
        ResourceLocation location;
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        if (appearance == null) {
            return null;
        }
        if (appearance.getSkinLocation() != null) {
            return appearance.getSkinLocation();
        }
        if (appearance.getSkinId() != null && !appearance.getSkinId().isEmpty() && (location = this.skinService.getSkinLocation(playerId, appearance.getSkinId())) != null) {
            appearance.setSkinLocation(location);
            TextureAlphaDetector.analyzeTextureAsync(location);
            return location;
        }
        return null;
    }

    @Nullable
    public ResourceLocation getCapeLocation(UUID playerId) {
        ResourceLocation location;
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        if (appearance == null) {
            return null;
        }
        if (appearance.getCapeLocation() != null) {
            return appearance.getCapeLocation();
        }
        if (appearance.getCapeId() != null && !appearance.getCapeId().isEmpty() && (location = this.capeService.getCapeLocation(playerId, appearance.getCapeId())) != null) {
            appearance.setCapeLocation(location);
            TextureAlphaDetector.analyzeTextureAsync(location);
            return location;
        }
        return null;
    }

    @Nullable
    public String getModelName(UUID playerId) {
        String override = this.modelService.getModelOverride(playerId);
        if (override != null) {
            PlayerAppearance appearance;
            if ("auto".equalsIgnoreCase(override) && (appearance = this.repository.getAppearance(playerId)) != null) {
                String skinId = appearance.getSkinId();
                return this.modelService.getModelType(playerId, skinId, "auto");
            }
            return override;
        }
        PlayerAppearance appearance = this.repository.getAppearance(playerId);
        return appearance != null ? appearance.getModel() : null;
    }

    public void reloadSkinsForTransparencyChange() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        QuickSkin.LOGGER.info("Reloading player skins for transparency change...");
        TextureAlphaDetector.clearCache();
        LocalAssetManager.getInstance().clearSkinTextureCache();
        NetworkTextureCache.getInstance().reprocessSkins();
        Screen screen = mc.f_91080_;
        if (screen instanceof PlayerSkinMenuScreen) {
            PlayerSkinMenuScreen skinMenu = (PlayerSkinMenuScreen)screen;
            skinMenu.refreshSkinList();
        }
        if (mc.f_91073_ != null && mc.f_91073_.m_6907_() != null) {
            ArrayList players = new ArrayList(mc.f_91073_.m_6907_());
            for (Player player : players) {
                PlayerAppearance appearance;
                if (player == null || (appearance = this.getAppearance(player.m_20148_())) == null) continue;
                appearance.setSkinLocation(null);
                this.applyLook(player.m_20148_(), appearance.getSkinId(), appearance.getCapeId(), appearance.getModel());
            }
        }
    }
}

