/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.storage;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextureChunkReceiver {
    private static TextureChunkReceiver instance;
    private final Map<String, ChunkAssembly> incompleteTextures = new ConcurrentHashMap<String, ChunkAssembly>();

    private TextureChunkReceiver() {
    }

    public static TextureChunkReceiver getInstance() {
        if (instance == null) {
            instance = new TextureChunkReceiver();
        }
        return instance;
    }

    public void receiveChunk(String hash, int chunkIndex, int totalChunks, byte[] chunkData) {
        ChunkAssembly assembly = this.incompleteTextures.computeIfAbsent(hash, k -> new ChunkAssembly(totalChunks));
        if (assembly.addChunk(chunkIndex, chunkData)) {
            byte[] completeData = assembly.assembleTexture();
            if (completeData != null) {
                QuickSkin.LOGGER.info("Assembled complete texture from {} chunks: {} ({} bytes)", new Object[]{totalChunks, hash, completeData.length});
                Minecraft.m_91087_().execute(() -> {
                    NetworkTextureCache.getInstance().storeTexture(hash, null, completeData);
                    QuickSkin.LOGGER.debug("Stored reassembled texture in network cache: {}", (Object)hash);
                });
            }
            this.incompleteTextures.remove(hash);
        }
    }

    public void clear() {
        this.incompleteTextures.clear();
        QuickSkin.LOGGER.debug("Cleared all incomplete texture assemblies");
    }

    private static class ChunkAssembly {
        private final byte[][] chunks;
        private final boolean[] received;
        private int receivedCount = 0;

        public ChunkAssembly(int totalChunks) {
            this.chunks = new byte[totalChunks][];
            this.received = new boolean[totalChunks];
        }

        public synchronized boolean addChunk(int index, byte[] data) {
            if (index < 0 || index >= this.chunks.length) {
                QuickSkin.LOGGER.warn("Invalid chunk index: {} (expected 0-{})", (Object)index, (Object)(this.chunks.length - 1));
                return false;
            }
            if (this.received[index]) {
                QuickSkin.LOGGER.debug("Ignoring duplicate chunk: {}", (Object)index);
                return false;
            }
            this.chunks[index] = data;
            this.received[index] = true;
            ++this.receivedCount;
            QuickSkin.LOGGER.debug("Received chunk {}/{}", (Object)this.receivedCount, (Object)this.chunks.length);
            return this.receivedCount == this.chunks.length;
        }

        public byte @Nullable [] assembleTexture() {
            if (this.receivedCount != this.chunks.length) {
                QuickSkin.LOGGER.warn("Cannot assemble texture: only {}/{} chunks received", (Object)this.receivedCount, (Object)this.chunks.length);
                return null;
            }
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                if (chunk == null) {
                    QuickSkin.LOGGER.error("Null chunk detected during assembly");
                    return null;
                }
                totalSize += chunk.length;
            }
            byte[] result = new byte[totalSize];
            int offset = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, result, offset, chunk.length);
                offset += chunk.length;
            }
            return result;
        }
    }
}

