/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.mixin;

import com.mojang.authlib.GameProfile;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.PlayerAppearance;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class}, priority=1100)
public abstract class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile f_105298_;

    @Inject(method={"getSkinLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$onGetSkinLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation customSkin;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if (service.hasActiveSkin(this.f_105298_.getId()) && (customSkin = service.getSkinLocation(this.f_105298_.getId())) != null) {
            cir.setReturnValue((Object)customSkin);
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$onGetModelName(CallbackInfoReturnable<String> cir) {
        String customModel;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if ((service.hasActiveSkin(this.f_105298_.getId()) || service.hasModelOverride(this.f_105298_.getId())) && (customModel = service.getModelName(this.f_105298_.getId())) != null) {
            cir.setReturnValue((Object)customModel);
        }
    }

    @Inject(method={"getCapeLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$onGetCapeLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if (service.hasActiveCape(this.f_105298_.getId())) {
            PlayerAppearance appearance = service.getAppearance(this.f_105298_.getId());
            if (appearance != null && ("__NONE__".equals(appearance.getCapeId()) || appearance.getCapeId().isEmpty())) {
                cir.setReturnValue(null);
                return;
            }
            ResourceLocation customCape = service.getCapeLocation(this.f_105298_.getId());
            cir.setReturnValue((Object)customCape);
        }
    }
}

