/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.ModNetworking;
import com.quickskin.mod.networking.packets.PacketHelper;
import com.quickskin.mod.server.data.ServerCooldownManager;
import com.quickskin.mod.server.data.ServerPlayerAppearanceRepository;
import com.quickskin.mod.server.storage.ServerAnimationCache;
import com.quickskin.mod.server.storage.ServerTextureCache;
import com.quickskin.mod.server.storage.TextureChunkAssembler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworkHandler {
    public static void handleUploadTexture(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UUID playerId = PacketHelper.readPlayerId(buf);
        String textureType = PacketHelper.readString(buf);
        byte[] imageData = PacketHelper.readByteArray(buf);
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null || !player.m_20148_().equals(playerId)) {
                QuickSkin.LOGGER.warn("Player UUID mismatch in upload texture packet");
                return;
            }
            QuickSkin.LOGGER.info("Received {} upload from player: {} (size: {} bytes)", new Object[]{textureType, player.m_7755_().getString(), imageData.length});
            String hash = playerId.toString() + "_" + textureType;
            ServerTextureCache.getInstance().storeTexture(hash, imageData);
            ServerNetworkHandler.broadcastTextureToOtherPlayers(player, textureType, hash, imageData);
        });
    }

    public static void handleUpdateAppearance(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UUID playerId = PacketHelper.readPlayerId(buf);
        String skinId = PacketHelper.readString(buf);
        String capeId = PacketHelper.readString(buf);
        String model = PacketHelper.readString(buf);
        context.queue(() -> {
            boolean isSkinChanging;
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null || !player.m_20148_().equals(playerId)) {
                QuickSkin.LOGGER.warn("Player UUID mismatch in update appearance packet");
                return;
            }
            int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
            PlayerAppearance currentAppearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(playerId);
            boolean bl = isSkinChanging = skinId != null && !skinId.isEmpty() && (currentAppearance == null || !skinId.equals(currentAppearance.getSkinId()));
            if (isSkinChanging && cooldownSeconds > 0 && ServerCooldownManager.getInstance().isPlayerOnCooldown(playerId)) {
                QuickSkin.LOGGER.warn("Player {} tried to change skin during cooldown. Change rejected.", (Object)player.m_7755_().getString());
                return;
            }
            QuickSkin.LOGGER.info("Player {} updated appearance: skin={}, cape={}, model={}", new Object[]{player.m_7755_().getString(), skinId, capeId, model});
            ServerPlayerAppearanceRepository.getInstance().updateAppearance(playerId, skinId, capeId, model);
            if (isSkinChanging && cooldownSeconds > 0) {
                ServerCooldownManager.getInstance().recordSkinChange(playerId);
                long cooldownEndTime = ServerCooldownManager.getInstance().getCooldownEndTime(playerId);
                FriendlyByteBuf cooldownBuf = new FriendlyByteBuf(Unpooled.buffer());
                cooldownBuf.writeLong(cooldownEndTime);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModNetworking.COOLDOWN_UPDATE, (FriendlyByteBuf)cooldownBuf);
                QuickSkin.LOGGER.debug("Sent cooldown update to player {}", (Object)player.m_7755_().getString());
            }
            ServerNetworkHandler.broadcastAppearanceToOtherPlayers(player, skinId, capeId, model);
        });
    }

    public static void handleRequestTexture(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UUID playerId = PacketHelper.readPlayerId(buf);
        String textureType = PacketHelper.readString(buf);
        String hash = PacketHelper.readString(buf);
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            QuickSkin.LOGGER.info("Player {} requested {} texture: {}", new Object[]{player.m_7755_().getString(), textureType, hash});
            byte[] textureData = ServerTextureCache.getInstance().getTexture(hash);
            if (textureData != null) {
                ServerNetworkHandler.sendTextureToClient(player, textureType, hash, textureData);
            } else {
                QuickSkin.LOGGER.warn("Requested texture not found: {}", (Object)hash);
            }
        });
    }

    public static void handleTextureChunk(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String hash = PacketHelper.readString(buf);
        String textureType = PacketHelper.readString(buf);
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        byte[] chunkData = PacketHelper.readByteArray(buf);
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            if (chunkData.length > 32768) {
                QuickSkin.LOGGER.warn("Rejecting oversized chunk from {}: {} bytes (max: 32KB)", (Object)player.m_7755_().getString(), (Object)chunkData.length);
                return;
            }
            if (chunkIndex < 0 || chunkIndex >= totalChunks) {
                QuickSkin.LOGGER.warn("Invalid chunk index from {}: {}/{}", new Object[]{player.m_7755_().getString(), chunkIndex, totalChunks});
                return;
            }
            if (totalChunks < 1 || totalChunks > 1000) {
                QuickSkin.LOGGER.warn("Invalid total chunks from {}: {}", (Object)player.m_7755_().getString(), (Object)totalChunks);
                return;
            }
            QuickSkin.LOGGER.debug("Received texture chunk {}/{} from {} (type: {}, hash: {})", new Object[]{chunkIndex + 1, totalChunks, player.m_7755_().getString(), textureType, hash});
            byte[] completeTexture = TextureChunkAssembler.getInstance().addChunk(hash, chunkIndex, totalChunks, chunkData);
            if (completeTexture != null) {
                QuickSkin.LOGGER.info("Received complete {} texture from player: {} (size: {} bytes)", new Object[]{textureType, player.m_7755_().getString(), completeTexture.length});
                ServerTextureCache.getInstance().storeTexture(hash, completeTexture);
                ServerNetworkHandler.broadcastTextureToOtherPlayers(player, textureType, hash, completeTexture);
            }
        });
    }

    public static void handleUploadAnimationMetadata(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String hash = PacketHelper.readString(buf);
        String metadataJson = PacketHelper.readString(buf);
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            QuickSkin.LOGGER.info("Player {} uploaded animation metadata for: {}", (Object)player.m_7755_().getString(), (Object)hash);
            ServerAnimationCache.getInstance().storeMetadata(hash, metadataJson);
            ServerNetworkHandler.broadcastAnimationMetadataToOtherPlayers(player, hash, metadataJson);
        });
    }

    public static void handleUpdateServerConfig(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String key = PacketHelper.readString(buf);
        boolean value = buf.readBoolean();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            if (!player.m_20310_(2)) {
                QuickSkin.LOGGER.warn("Player {} tried to change server config without permission", (Object)player.m_7755_().getString());
                return;
            }
            QuickSkin.LOGGER.info("Admin {} updated server config: {} = {}", new Object[]{player.m_7755_().getString(), key, value});
            ServerConfig serverConfig = ServerConfig.getInstance();
            switch (key) {
                case "disableSkinTransparency": {
                    serverConfig.disableSkinTransparency = value;
                    break;
                }
                default: {
                    QuickSkin.LOGGER.warn("Unknown server config key: {}", (Object)key);
                    return;
                }
            }
            serverConfig.save();
            ServerNetworkHandler.broadcastServerConfigToAllPlayers(player.f_8924_);
        });
    }

    private static void broadcastTextureToOtherPlayers(ServerPlayer player, String textureType, String hash, byte[] imageData) {
        for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
            if (otherPlayer.m_20148_().equals(player.m_20148_())) continue;
            FriendlyByteBuf packet = PacketHelper.createSendTexturePacket(textureType, hash, imageData);
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (ResourceLocation)ModNetworking.SEND_TEXTURE, (FriendlyByteBuf)packet);
        }
        QuickSkin.LOGGER.debug("Broadcasted {} texture from {} to {} players", new Object[]{textureType, player.m_7755_().getString(), player.f_8924_.m_6846_().m_11309_() - 1});
    }

    private static void broadcastAppearanceToOtherPlayers(ServerPlayer player, String skinId, String capeId, String model) {
        for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
            if (otherPlayer.m_20148_().equals(player.m_20148_())) continue;
            FriendlyByteBuf packet = PacketHelper.createSyncAppearancePacket(player.m_20148_(), skinId, capeId, model);
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (ResourceLocation)ModNetworking.SYNC_APPEARANCE, (FriendlyByteBuf)packet);
        }
        QuickSkin.LOGGER.debug("Broadcasted appearance from {} to {} players", (Object)player.m_7755_().getString(), (Object)(player.f_8924_.m_6846_().m_11309_() - 1));
    }

    public static void sendAppearanceToPlayer(ServerPlayer recipient, UUID targetPlayerId) {
        PlayerAppearance appearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(targetPlayerId);
        if (appearance != null) {
            String hash;
            FriendlyByteBuf packet = PacketHelper.createSyncAppearancePacket(targetPlayerId, appearance.getSkinId(), appearance.getCapeId(), appearance.getModel());
            NetworkManager.sendToPlayer((ServerPlayer)recipient, (ResourceLocation)ModNetworking.SYNC_APPEARANCE, (FriendlyByteBuf)packet);
            String skinId = appearance.getSkinId();
            String capeId = appearance.getCapeId();
            if (skinId != null && skinId.startsWith("local_skin:")) {
                hash = skinId.substring("local_skin:".length());
                byte[] skinData = ServerTextureCache.getInstance().getTexture(hash);
                if (skinData != null) {
                    FriendlyByteBuf skinPacket = PacketHelper.createSendTexturePacket("skin", hash, skinData);
                    NetworkManager.sendToPlayer((ServerPlayer)recipient, (ResourceLocation)ModNetworking.SEND_TEXTURE, (FriendlyByteBuf)skinPacket);
                    QuickSkin.LOGGER.debug("Sent skin texture {} to {}", (Object)hash, (Object)recipient.m_7755_().getString());
                }
            }
            if (capeId != null && capeId.startsWith("local_cape:")) {
                hash = capeId.substring("local_cape:".length());
                byte[] capeData = ServerTextureCache.getInstance().getTexture(hash);
                if (capeData != null) {
                    FriendlyByteBuf capePacket = PacketHelper.createSendTexturePacket("cape", hash, capeData);
                    NetworkManager.sendToPlayer((ServerPlayer)recipient, (ResourceLocation)ModNetworking.SEND_TEXTURE, (FriendlyByteBuf)capePacket);
                    QuickSkin.LOGGER.debug("Sent cape texture {} to {}", (Object)hash, (Object)recipient.m_7755_().getString());
                    String metadata = ServerAnimationCache.getInstance().getMetadata(hash);
                    if (metadata != null) {
                        FriendlyByteBuf animPacket = PacketHelper.createSendAnimationMetadataPacket(hash, metadata);
                        NetworkManager.sendToPlayer((ServerPlayer)recipient, (ResourceLocation)ModNetworking.SEND_ANIMATION_METADATA, (FriendlyByteBuf)animPacket);
                        QuickSkin.LOGGER.debug("Sent animation metadata for {} to {}", (Object)hash, (Object)recipient.m_7755_().getString());
                    }
                }
            }
            QuickSkin.LOGGER.debug("Sent appearance of {} to {}", (Object)targetPlayerId, (Object)recipient.m_7755_().getString());
        }
    }

    public static void sendAllAppearancesToPlayer(ServerPlayer player) {
        for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
            if (otherPlayer.m_20148_().equals(player.m_20148_())) continue;
            ServerNetworkHandler.sendAppearanceToPlayer(player, otherPlayer.m_20148_());
        }
        QuickSkin.LOGGER.debug("Sent all player appearances to {}", (Object)player.m_7755_().getString());
    }

    public static void sendAppearanceToAllPlayers(ServerPlayer player) {
        PlayerAppearance appearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(player.m_20148_());
        if (appearance != null) {
            for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
                if (otherPlayer.m_20148_().equals(player.m_20148_())) continue;
                ServerNetworkHandler.sendAppearanceToPlayer(otherPlayer, player.m_20148_());
            }
            QuickSkin.LOGGER.debug("Sent appearance of {} to all other players", (Object)player.m_7755_().getString());
        } else {
            QuickSkin.LOGGER.debug("No appearance found for {}, skipping broadcast to other players", (Object)player.m_7755_().getString());
        }
    }

    private static void sendTextureToClient(ServerPlayer player, String textureType, String hash, byte[] textureData) {
        FriendlyByteBuf packet = PacketHelper.createSendTexturePacket(textureType, hash, textureData);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModNetworking.SEND_TEXTURE, (FriendlyByteBuf)packet);
        QuickSkin.LOGGER.debug("Sent {} texture {} to {}", new Object[]{textureType, hash, player.m_7755_().getString()});
    }

    private static void broadcastAnimationMetadataToOtherPlayers(ServerPlayer player, String hash, String metadataJson) {
        for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
            if (otherPlayer.m_20148_().equals(player.m_20148_())) continue;
            FriendlyByteBuf packet = PacketHelper.createSendAnimationMetadataPacket(hash, metadataJson);
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (ResourceLocation)ModNetworking.SEND_ANIMATION_METADATA, (FriendlyByteBuf)packet);
        }
        QuickSkin.LOGGER.debug("Broadcasted animation metadata for {} to {} players", (Object)hash, (Object)(player.f_8924_.m_6846_().m_11309_() - 1));
    }

    public static void sendServerConfigToPlayer(ServerPlayer player) {
        ServerConfig serverConfig = ServerConfig.getInstance();
        String configJson = serverConfig.toJson();
        FriendlyByteBuf packet = PacketHelper.createSyncServerConfigPacket(configJson);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModNetworking.SYNC_SERVER_CONFIG, (FriendlyByteBuf)packet);
        QuickSkin.LOGGER.debug("Sent server config to {}", (Object)player.m_7755_().getString());
    }

    private static void broadcastServerConfigToAllPlayers(MinecraftServer server) {
        ServerConfig serverConfig = ServerConfig.getInstance();
        String configJson = serverConfig.toJson();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            FriendlyByteBuf packet = PacketHelper.createSyncServerConfigPacket(configJson);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModNetworking.SYNC_SERVER_CONFIG, (FriendlyByteBuf)packet);
        }
        QuickSkin.LOGGER.info("Broadcasted server config to all {} players", (Object)server.m_6846_().m_11309_());
    }
}

