/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.data;

import com.quickskin.mod.config.ServerConfig;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ServerCooldownManager {
    private static final ServerCooldownManager INSTANCE = new ServerCooldownManager();
    private final Map<UUID, Long> lastSkinChangeTimestamps = new ConcurrentHashMap<UUID, Long>();

    private ServerCooldownManager() {
    }

    public static ServerCooldownManager getInstance() {
        return INSTANCE;
    }

    public boolean isPlayerOnCooldown(UUID playerId) {
        int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
        if (cooldownSeconds <= 0) {
            return false;
        }
        long lastChangeTime = this.lastSkinChangeTimestamps.getOrDefault(playerId, 0L);
        long cooldownMillis = (long)cooldownSeconds * 1000L;
        return System.currentTimeMillis() - lastChangeTime < cooldownMillis;
    }

    public void recordSkinChange(UUID playerId) {
        this.lastSkinChangeTimestamps.put(playerId, System.currentTimeMillis());
    }

    public long getCooldownEndTime(UUID playerId) {
        int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
        if (cooldownSeconds <= 0) {
            return 0L;
        }
        long lastChangeTime = this.lastSkinChangeTimestamps.getOrDefault(playerId, 0L);
        return lastChangeTime + (long)cooldownSeconds * 1000L;
    }

    public long getLastChangeTime(UUID playerId) {
        return this.lastSkinChangeTimestamps.getOrDefault(playerId, 0L);
    }

    public void removePlayer(UUID playerId) {
        this.lastSkinChangeTimestamps.remove(playerId);
    }
}

